/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.serde.AbstractKafkaDeserializer;
import io.apicurio.registry.utils.serde.avro.AvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class AvroKafkaDeserializer<U>
extends AbstractKafkaDeserializer<Schema, U, AvroKafkaDeserializer<U>> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    private AvroDatumProvider<U> avroDatumProvider;

    public AvroKafkaDeserializer() {
        this(null);
    }

    public AvroKafkaDeserializer(RegistryService client) {
        this(client, new DefaultAvroDatumProvider());
    }

    public AvroKafkaDeserializer(RegistryService client, AvroDatumProvider<U> avroDatumProvider) {
        super(client);
        this.setAvroDatumProvider(avroDatumProvider);
    }

    public AvroKafkaDeserializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        Object adp = configs.get("apicurio.registry.avro-datum-provider");
        Consumer<AvroDatumProvider> consumer = ((Consumer<AvroDatumProvider>)avroDatumProvider -> avroDatumProvider.configure(configs)).andThen(this::setAvroDatumProvider);
        this.instantiate(AvroDatumProvider.class, adp, consumer);
    }

    @Override
    protected Schema toSchema(Response response) {
        return AvroSchemaUtils.parse((String)response.readEntity(String.class));
    }

    @Override
    protected U readData(Schema schema, ByteBuffer buffer, int start, int length) {
        try {
            DatumReader<U> reader = this.avroDatumProvider.createDatumReader(schema);
            return (U)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(buffer.array(), start, length, null));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

