/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.serde.AbstractKafkaSerializer;
import io.apicurio.registry.utils.serde.avro.AvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.NonRecordContainer;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class AvroKafkaSerializer<U>
extends AbstractKafkaSerializer<Schema, U, AvroKafkaSerializer<U>> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private AvroDatumProvider<U> avroDatumProvider = new DefaultAvroDatumProvider<U>();

    public AvroKafkaSerializer() {
    }

    public AvroKafkaSerializer(RegistryService client) {
        super(client);
    }

    public AvroKafkaSerializer(RegistryService client, ArtifactIdStrategy<Schema> artifactIdStrategy, GlobalIdStrategy<Schema> idStrategy) {
        super(client, artifactIdStrategy, idStrategy);
    }

    public AvroKafkaSerializer(RegistryService client, ArtifactIdStrategy<Schema> artifactIdStrategy, GlobalIdStrategy<Schema> globalIdStrategy, AvroDatumProvider<U> avroDatumProvider) {
        super(client, artifactIdStrategy, globalIdStrategy);
        this.setAvroDatumProvider(avroDatumProvider);
    }

    public AvroKafkaSerializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        Object adp = configs.get("apicurio.registry.avro-datum-provider");
        Consumer<AvroDatumProvider> consumer = ((Consumer<AvroDatumProvider>)avroDatumProvider -> avroDatumProvider.configure(configs)).andThen(this::setAvroDatumProvider);
        this.instantiate(AvroDatumProvider.class, adp, consumer);
    }

    @Override
    protected Schema toSchema(U data) {
        return this.avroDatumProvider.toSchema(data);
    }

    @Override
    protected ArtifactType artifactType() {
        return ArtifactType.AVRO;
    }

    @Override
    protected void serializeData(Schema schema, U data, OutputStream out) throws IOException {
        BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(out, null);
        if (data instanceof NonRecordContainer) {
            data = ((NonRecordContainer)NonRecordContainer.class.cast(data)).getValue();
        }
        DatumWriter<U> writer = this.avroDatumProvider.createDatumWriter(data, schema);
        writer.write(data, (Encoder)encoder);
        encoder.flush();
    }
}

