/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.kafka.common.utils.CloseableIterator;

public abstract class AbstractStreamToIteratorAdapter<I, O>
implements CloseableIterator<O>,
Consumer<I> {
    private final Stream<I> stream;
    private Spliterator<I> spliterator;
    private I next;

    public AbstractStreamToIteratorAdapter(Stream<I> stream) {
        this.stream = stream;
    }

    @Override
    public void accept(I kv) {
        this.next = Objects.requireNonNull(kv, "Stream should not contain null elements");
    }

    public boolean hasNext() {
        if (this.next == null) {
            Spliterator<Object> spliterator = this.spliterator;
            if (spliterator == null) {
                spliterator = this.stream.spliterator();
                this.spliterator = spliterator;
            }
            return spliterator.tryAdvance(this);
        }
        return true;
    }

    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        I res = this.next;
        this.next = null;
        return this.deserialize(res);
    }

    protected abstract O deserialize(I var1);

    public void close() {
        this.stream.close();
    }
}

