/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import io.apicurio.registry.utils.streams.distore.ExtReadOnlyKeyValueStore;
import io.apicurio.registry.utils.streams.distore.FilterPredicate;
import io.apicurio.registry.utils.streams.distore.StreamToKeyValueIteratorAdapter;
import java.util.stream.Stream;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class ExtReadOnlyKeyValueStoreImpl<K, V>
implements ExtReadOnlyKeyValueStore<K, V> {
    private final ReadOnlyKeyValueStore<K, V> delegate;
    private final FilterPredicate<K, V> filterPredicate;

    public ExtReadOnlyKeyValueStoreImpl(ReadOnlyKeyValueStore<K, V> delegate, FilterPredicate<K, V> filterPredicate) {
        this.delegate = delegate;
        this.filterPredicate = filterPredicate;
    }

    @Override
    public Stream<K> allKeys() {
        return StreamToKeyValueIteratorAdapter.toStream(this.all()).map(kv -> kv.key);
    }

    @Override
    public Stream<KeyValue<K, V>> filter(String filter, String over) {
        return StreamToKeyValueIteratorAdapter.toStream(this.all()).filter(kv -> this.filterPredicate.test(filter, over, kv.key, kv.value));
    }

    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    public KeyValueIterator<K, V> range(K from, K to) {
        return this.delegate.range(from, to);
    }

    public KeyValueIterator<K, V> all() {
        return this.delegate.all();
    }

    public long approximateNumEntries() {
        return this.delegate.approximateNumEntries();
    }
}

