/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;

public class KeyValueSerde<K, V> {
    private final String serdeTopic;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;

    public KeyValueSerde(String serdeTopic, Serde<K> keySerde, Serde<V> valSerde) {
        this.serdeTopic = serdeTopic;
        this.keySerde = Objects.requireNonNull(keySerde);
        this.valSerde = Objects.requireNonNull(valSerde);
    }

    public K deserializeKey(byte[] data) {
        return (K)this.keySerde.deserializer().deserialize(this.serdeTopic, data);
    }

    public V deserializeVal(byte[] data) {
        return (V)this.valSerde.deserializer().deserialize(this.serdeTopic, data);
    }

    public byte[] serializeKey(K key) {
        return this.keySerde.serializer().serialize(this.serdeTopic, key);
    }

    public byte[] serializeVal(V val) {
        return this.valSerde.serializer().serialize(this.serdeTopic, val);
    }

    public static Registry newRegistry() {
        return new Registry();
    }

    public static class Registry {
        private final Map<String, KeyValueSerde<?, ?>> registry = new HashMap();

        Registry() {
        }

        public <K, V> Registry register(String storeName, Serde<K> keySerde, Serde<V> valSerde) {
            this.registry.put(storeName, new KeyValueSerde<K, V>(storeName + "-serde-topic", keySerde, valSerde));
            return this;
        }

        public <K, V> KeyValueSerde<K, V> keyValueSerde(String storeName) {
            KeyValueSerde<?, ?> kvSerde = this.registry.get(storeName);
            if (kvSerde == null) {
                throw new IllegalStateException("Key/Value Serde(s) for store with name: '" + storeName + "' are not registered.");
            }
            return kvSerde;
        }

        public <K> K deserializeKey(String storeName, byte[] data) {
            return this.keyValueSerde(storeName).deserializeKey(data);
        }

        public <V> V deserializeVal(String storeName, byte[] data) {
            return this.keyValueSerde(storeName).deserializeVal(data);
        }

        public <K> byte[] serializeKey(String storeName, K key) {
            return this.keyValueSerde(storeName).serializeKey(key);
        }

        public <V> byte[] serializeVal(String storeName, V val) {
            return this.keyValueSerde(storeName).serializeVal(val);
        }
    }
}

