/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.ext;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStateRestoreListener
implements StateRestoreListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingStateRestoreListener.class);

    public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
        log.info("restore start: topicPartition={}, storeName={}, startingOffset={}, endingOffset={}", new Object[]{topicPartition, storeName, startingOffset, endingOffset});
    }

    public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
        log.info("batch restored: topicPartition={}, storeName={}, batchEndOffset={}, numRestored={}", new Object[]{topicPartition, storeName, batchEndOffset, numRestored});
    }

    public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
        log.info("restore end: topicPartition={}, storeName={}, totalRestored={}", new Object[]{topicPartition, storeName, totalRestored});
    }
}

