/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.ext;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@FunctionalInterface
public interface LongGenerator {
    public long getNext();

    public static class HiLo
    implements LongGenerator {
        private final LongGenerator hiGenerator;
        private final AtomicLong hilo = new AtomicLong();
        private final Object lock = new Object();
        private final int loBits;
        private final long loMask;

        public HiLo(LongGenerator hiGenerator) {
            this(hiGenerator, 16);
        }

        public HiLo(LongGenerator hiGenerator, int loBits) {
            this.hiGenerator = Objects.requireNonNull(hiGenerator);
            if (loBits < 1 || loBits > 62) {
                throw new IllegalArgumentException("loBits must be between 1 and 62");
            }
            this.loBits = loBits;
            this.loMask = (1L << loBits) - 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getNext() {
            long hl;
            while (true) {
                if (((hl = this.hilo.get()) & this.loMask) == 0L) {
                    Object object = this.lock;
                    synchronized (object) {
                        hl = this.hilo.get();
                        if ((hl & this.loMask) == 0L) {
                            hl = this.hiGenerator.getNext() << this.loBits | hl & this.loMask;
                            this.hilo.set(hl + 1L);
                            return hl;
                        }
                    }
                }
                if (this.hilo.compareAndSet(hl, hl + 1L)) break;
            }
            return hl;
        }
    }
}

