/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.diservice;

import com.google.protobuf.ByteString;
import io.apicurio.registry.utils.streams.diservice.AsyncBiFunctionService;
import io.apicurio.registry.utils.streams.diservice.StreamObserverCompletableFuture;
import io.apicurio.registry.utils.streams.diservice.proto.AsyncBiFunctionServiceGrpc;
import io.apicurio.registry.utils.streams.diservice.proto.BiFunctionReq;
import io.apicurio.registry.utils.streams.diservice.proto.BiFunctionRes;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.apache.kafka.common.serialization.Serde;

public class AsyncBiFunctionServiceGrpcClient<K, REQ, RES>
implements AsyncBiFunctionService<K, REQ, RES> {
    private final String serviceName;
    private final Channel channel;
    private final AsyncBiFunctionServiceGrpc.AsyncBiFunctionServiceStub stub;
    private final Serde<K> keySerde;
    private final Serde<REQ> reqSerde;
    private final Serde<RES> resSerde;

    public AsyncBiFunctionServiceGrpcClient(String serviceName, Channel channel, Serde<K> keySerde, Serde<REQ> reqSerde, Serde<RES> resSerde) {
        this.serviceName = serviceName;
        this.channel = channel;
        this.stub = AsyncBiFunctionServiceGrpc.newStub(channel);
        this.keySerde = keySerde;
        this.reqSerde = reqSerde;
        this.resSerde = resSerde;
    }

    @Override
    public void close() {
        if (this.channel instanceof ManagedChannel) {
            ((ManagedChannel)this.channel).shutdown();
        }
    }

    @Override
    public CompletionStage<RES> apply(K key, REQ req) {
        byte[] keyBytes = this.keySerde.serializer().serialize(this.serviceName, key);
        byte[] reqBytes = this.reqSerde.serializer().serialize(this.serviceName, req);
        ByteString keyByteStr = keyBytes == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])keyBytes);
        ByteString reqByteStr = reqBytes == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])reqBytes);
        BiFunctionReq reqProto = BiFunctionReq.newBuilder().setKey(keyByteStr).setReq(reqByteStr).setServiceName(this.serviceName).build();
        StreamObserverCompletableFuture<BiFunctionRes> observerCF = new StreamObserverCompletableFuture<BiFunctionRes>();
        this.stub.apply(reqProto, observerCF);
        return observerCF.thenApply(resProto -> this.resSerde.deserializer().deserialize(this.serviceName, resProto.getRes().isEmpty() ? null : resProto.getRes().toByteArray()));
    }

    @Override
    public Stream<CompletionStage<RES>> applyForStore() {
        return this.apply();
    }

    @Override
    public Stream<CompletionStage<RES>> apply() {
        return Stream.of(this.apply((Object)null, (Object)null));
    }
}

