/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.diservice;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LocalService<S> {
    private String serviceName;
    private S service;

    public LocalService(String serviceName, S service) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.service = Objects.requireNonNull(service);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public S getService() {
        return this.service;
    }

    public static final class Registry<S> {
        private final Map<String, ? extends S> registry;

        public Registry(Collection<LocalService<? extends S>> localServices) {
            this.registry = localServices.stream().collect(Collectors.toMap(LocalService::getServiceName, LocalService::getService));
        }

        public S get(String serviceName) {
            S service = this.registry.get(serviceName);
            if (service == null) {
                throw new IllegalStateException("No local service with name: " + serviceName + " registered");
            }
            return service;
        }
    }
}

