/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import io.grpc.stub.StreamObserver;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamObserverSpliterator<T>
extends Spliterators.AbstractSpliterator<T>
implements StreamObserver<T> {
    private static final Object EOS = new Object();
    private final BlockingQueue<Object> queue = new LinkedTransferQueue<Object>();
    private boolean finished;

    public StreamObserverSpliterator() {
        super(Long.MAX_VALUE, 1296);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(() -> this, 1296, false);
    }

    public void onNext(T t) {
        this.queue.add(t);
    }

    public void onError(Throwable throwable) {
        this.queue.add(new ExceptionWrapper(throwable));
    }

    public void onCompleted() {
        this.queue.add(EOS);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Object res;
        if (this.finished) {
            return false;
        }
        try {
            res = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (res == EOS) {
            this.finished = true;
            return false;
        }
        if (res instanceof ExceptionWrapper) {
            this.finished = true;
            ((ExceptionWrapper)res).throwException();
            return false;
        }
        Object t = res;
        action.accept(t);
        return true;
    }

    private static class ExceptionWrapper {
        final Throwable exception;

        ExceptionWrapper(Throwable exception) {
            this.exception = exception;
        }

        void throwException() {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            if (this.exception instanceof Error) {
                throw (Error)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
    }
}

