/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;

public class StreamToKeyValueIteratorAdapter<K, V>
implements KeyValueIterator<K, V>,
Consumer<KeyValue<K, V>> {
    private final Stream<KeyValue<K, V>> stream;
    private Spliterator<KeyValue<K, V>> spliterator;
    private KeyValue<K, V> next;

    public StreamToKeyValueIteratorAdapter(Stream<KeyValue<K, V>> stream) {
        this.stream = Objects.requireNonNull(stream);
    }

    @Override
    public void accept(KeyValue<K, V> kv) {
        this.next = Objects.requireNonNull(kv, "Stream should not contain null elements");
    }

    public boolean hasNext() {
        if (this.next == null) {
            Spliterator<Object> spliterator = this.spliterator;
            if (spliterator == null) {
                spliterator = this.stream.spliterator();
                this.spliterator = spliterator;
            }
            return spliterator.tryAdvance(this);
        }
        return true;
    }

    public K peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (K)this.next.key;
    }

    public KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue<K, V> res = this.next;
        this.next = null;
        return res;
    }

    public void close() {
        this.stream.close();
    }

    public static <K, V> Stream<KeyValue<K, V>> toStream(KeyValueIterator<K, V> kvIterator) {
        if (kvIterator instanceof StreamToKeyValueIteratorAdapter) {
            return ((StreamToKeyValueIteratorAdapter)kvIterator).stream;
        }
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(kvIterator, 1296), false).onClose(() -> kvIterator.close());
    }
}

