/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.distore;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class UnknownStatusDescriptionInterceptor
implements ServerInterceptor {
    private final Map<Class<? extends Throwable>, Status> throwableRootsStatuses;

    public UnknownStatusDescriptionInterceptor(Map<Class<? extends Throwable>, Status> throwableRootsStatuses) {
        this.throwableRootsStatuses = new HashMap<Class<? extends Throwable>, Status>(throwableRootsStatuses);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ForwardingServerCall.SimpleForwardingServerCall wrappedCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendMessage(RespT message) {
                super.sendMessage(message);
            }

            public void close(Status status, Metadata trailers) {
                Status newStatus;
                Throwable exception;
                if (status.getCode() == Status.Code.UNKNOWN && status.getDescription() == null && (exception = status.getCause()) != null && (newStatus = UnknownStatusDescriptionInterceptor.this.statusForException(exception)) != null) {
                    status = newStatus.withCause(exception).withDescription(UnknownStatusDescriptionInterceptor.this.stacktraceToString(exception));
                }
                super.close(status, trailers);
            }
        };
        return next.startCall((ServerCall)wrappedCall, headers);
    }

    private Status statusForException(Throwable exception) {
        Class<?> excCls = exception.getClass();
        do {
            Status status;
            if ((status = this.throwableRootsStatuses.get(excCls)) == null) continue;
            return status;
        } while ((excCls = excCls.getSuperclass()) != Object.class);
        return null;
    }

    private String stacktraceToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

