/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.streams.ext;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.kafka.streams.kstream.ForeachAction;

public class ForeachActionDispatcher<K, V>
implements ForeachAction<K, V> {
    private final List<ForeachAction<? super K, ? super V>> actions = new CopyOnWriteArrayList<ForeachAction<? super K, ? super V>>();

    public void apply(K key, V value) {
        for (ForeachAction<? super K, ? super V> foreachAction : this.actions) {
            foreachAction.apply(key, value);
        }
    }

    public void register(ForeachAction<? super K, ? super V> action) {
        this.actions.add(Objects.requireNonNull(action));
    }

    public void deregister(ForeachAction<? super K, ? super V> action) {
        this.actions.remove(Objects.requireNonNull(action));
    }
}

