/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.tenantmanager.client.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.ApicurioRestClientException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.util.IoUtil;
import io.apicurio.tenantmanager.client.exception.ApicurioTenantNotFoundException;
import io.apicurio.tenantmanager.client.exception.TenantManagerClientException;
import java.io.InputStream;

public class TenantManagerClientErrorHandler
implements RestClientErrorHandler {
    public ApicurioRestClientException handleErrorResponse(InputStream body, int statusCode) {
        switch (statusCode) {
            case 401: {
                return new NotAuthorizedException(IoUtil.toString((InputStream)body));
            }
            case 403: {
                return new ForbiddenException(IoUtil.toString((InputStream)body));
            }
            case 404: {
                return new ApicurioTenantNotFoundException(IoUtil.toString((InputStream)body));
            }
        }
        return new TenantManagerClientException(IoUtil.toString((InputStream)body));
    }

    public ApicurioRestClientException parseError(Exception e) {
        throw new TenantManagerClientException(e.getMessage());
    }

    public ApicurioRestClientException parseInputSerializingError(JsonProcessingException e) {
        throw new TenantManagerClientException(e.getMessage());
    }
}

