/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.tenantmanager.api.datamodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TenantStatusValue {
    READY("READY"),
    TO_BE_DELETED("TO_BE_DELETED"),
    DELETED("DELETED");

    private final String value;
    private static final Map<String, TenantStatusValue> CONSTANTS;

    private TenantStatusValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TenantStatusValue fromValue(String value) {
        TenantStatusValue constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TenantStatusValue>();
        for (TenantStatusValue c : TenantStatusValue.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

