/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.mavenplugin;

import io.apigee.buildTools.enterprise4g.mavenplugin.GatewayAbstractMojo;
import io.apigee.buildTools.enterprise4g.utils.PackageConfigurer;
import io.apigee.buildTools.enterprise4g.utils.ZipUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureMojo
extends GatewayAbstractMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] filesInExternalNodeDir;
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(ConfigureMojo.class);
        File configFile = this.findConfigFile(logger);
        if (configFile != null) {
            this.configurePackage(logger, configFile);
        }
        logger.info("\n\n=============Checking for node.js app================\n\n");
        String externalNodeDirPath = super.getBaseDirectoryPath() + "/node/";
        File externalNodeDir = new File(externalNodeDirPath);
        String nodeDirPath = super.getBuildDirectory() + "/apiproxy/resources/node/";
        File nodeDir = new File(nodeDirPath);
        if (externalNodeDir.isDirectory() && (filesInExternalNodeDir = externalNodeDir.list()).length > 0) {
            logger.info("Node.js app code found outside apiproxy/ directory. Moving to target/apiproxy/resources/node (will overwrite).");
            try {
                FileUtils.deleteDirectory((File)nodeDir);
                FileUtils.copyDirectory((File)externalNodeDir, (File)nodeDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        if (nodeDir.isDirectory()) {
            String[] filesInNodeDir;
            logger.info("\n\n=============Now zipping node modules================\n\n");
            for (String fileName : filesInNodeDir = nodeDir.list()) {
                String filePath = nodeDirPath + fileName;
                File dirFile = new File(filePath);
                if (!dirFile.isDirectory() || !fileName.contains("node_modules")) continue;
                logger.info("Zipping " + fileName + " (it is a directory).");
                try {
                    ZipUtils zu = new ZipUtils();
                    zu.zipDir(new File(filePath + ".zip"), dirFile, fileName);
                    FileUtils.deleteDirectory((File)dirFile);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        logger.info("\n\n=============Now zipping the App Bundle================\n\n");
        try {
            ZipUtils zu = new ZipUtils();
            zu.zipDir(new File(super.getApplicationBundlePath()), new File(super.getBuildDirectory() + "/apiproxy"), "apiproxy");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void configurePackage(Logger logger, File configFile) throws MojoExecutionException {
        logger.debug("\n\n=============Now updating the configuration values for the App Bundle================\n\n");
        try {
            if (super.getProfile().getProfileId() != null && super.getProfile().getProfileId() != "") {
                PackageConfigurer.configurePackage(super.getProfile().getProfileId(), configFile);
            } else {
                PackageConfigurer.configurePackage(super.getProfile().getEnvironment(), configFile);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private File findConfigFile(Logger logger) throws MojoExecutionException {
        File configFile = new File(super.getBaseDirectoryPath() + File.separator + "config.json");
        if (configFile.exists()) {
            return configFile;
        }
        logger.info("No config.json found. Skipping package configuration.");
        return null;
    }
}

