/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.mavenplugin;

import io.apigee.buildTools.enterprise4g.mavenplugin.GatewayAbstractMojo;
import io.apigee.buildTools.enterprise4g.rest.RestUtil;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployMojo
extends GatewayAbstractMojo {
    public static final String DEPLOYMENT_FAILED_MESSAGE = "\n\n\n* * * * * * * * * * *\n\nThis deployment could have failed for a variety of reasons.\n\n\n\n* * * * * * * * * * *\n\n\n";
    static Logger logger = LoggerFactory.getLogger(DeployMojo.class);
    State state = State.START;
    String activeRevision = "";
    String bundleRevision = "";
    String revisionInArg = "";
    BUILDOPTIONS buildOption;

    public void init() throws IOException, MojoFailureException, Exception {
        try {
            String options = "";
            this.state = State.INIT;
            long delay = 0L;
            if (this.getBuildOption() != null) {
                String opt = this.getBuildOption();
                opt = opt.replace("-", "");
                this.buildOption = BUILDOPTIONS.valueOf(opt);
            } else {
                this.buildOption = BUILDOPTIONS.valueOf("NULL");
            }
            if (this.getDelay() != null) {
                RestUtil.Options.delay = delay = this.getDelay().longValue();
            }
            if (this.getOverridedelay() != null) {
                RestUtil.Options.override_delay = delay = this.getOverridedelay().longValue();
            }
            if ((options = super.getOptions()) != null) {
                String[] opts;
                block11: for (String opt : opts = options.split(",")) {
                    switch (OPTIONS.valueOf(opt)) {
                        case validate: {
                            RestUtil.Options.validate = true;
                            continue block11;
                        }
                        case force: {
                            RestUtil.Options.force = true;
                            continue block11;
                        }
                        case inactive: {
                            RestUtil.Options.inactive = true;
                            continue block11;
                        }
                        case clean: {
                            RestUtil.Options.clean = true;
                            continue block11;
                        }
                        case update: {
                            RestUtil.Options.update = true;
                            if (this.getRevision() == null) continue block11;
                            this.revisionInArg = String.valueOf(this.getRevision());
                            continue block11;
                        }
                        case override: {
                            RestUtil.Options.override = true;
                            continue block11;
                        }
                    }
                }
            }
            logger.info("\n\n=============Initializing Maven Deployment================\n\n");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void doImport() throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Importing App================\n\n");
            this.state = State.IMPORTING;
            this.bundleRevision = RestUtil.uploadBundle(super.getProfile(), super.getApplicationBundlePath());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void doUpdate(String revision) throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Updating App================\n\n");
            this.state = State.IMPORTING;
            this.bundleRevision = RestUtil.updateBundle(super.getProfile(), super.getApplicationBundlePath(), revision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void doDeactivae() throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Deactivating App================\n\n");
            this.state = State.DEACTIVATING;
            RestUtil.deactivateBundle(super.getProfile());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void doRefreshBundle() throws IOException, MojoFailureException {
        try {
            logger.info("\n\n=============Refresh Bundle================\n\n");
            this.state = State.ACTIVATING;
            RestUtil.refreshBundle(super.getProfile(), this.bundleRevision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void doActivateBundle() throws IOException, MojoFailureException {
        try {
            logger.info("\n\n=============Activating Bundle================\n\n");
            this.state = State.ACTIVATING;
            RestUtil.activateBundleRevision(super.getProfile(), this.bundleRevision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void doDelete(String revision) throws IOException, MojoFailureException, Exception {
        try {
            logger.info("/n/n=============Deleting App================/n/n");
            this.state = State.DELETING;
            RestUtil.deleteBundle(this.getProfile(), revision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.fixOSXNonProxyHosts();
            this.init();
            switch (this.buildOption) {
                case NULL: {
                    if (RestUtil.Options.override) {
                        this.activeRevision = RestUtil.getDeployedRevision(this.getProfile());
                        if (this.activeRevision.length() > 0) {
                            this.doImport();
                            this.doActivateBundle();
                            break;
                        }
                        RestUtil.Options.override = false;
                        this.doImport();
                        this.doActivateBundle();
                        break;
                    }
                    if (RestUtil.Options.update) {
                        String latestRev = "";
                        if (this.revisionInArg.length() > 0) {
                            logger.info("Updating Revision passed: " + this.revisionInArg);
                            this.doUpdate(this.revisionInArg);
                            break;
                        }
                        this.activeRevision = RestUtil.getDeployedRevision(this.getProfile());
                        if (this.activeRevision.length() > 0) {
                            logger.info("Active Revision: " + this.activeRevision);
                            logger.info("Updating Active Revision: " + this.activeRevision);
                            this.doUpdate(this.activeRevision);
                            break;
                        }
                        latestRev = RestUtil.getLatestRevision(this.getProfile());
                        if (latestRev.length() > 0) {
                            logger.info("Latest Revision: " + latestRev);
                            logger.info("Updating Latest Revision: " + latestRev);
                            this.doUpdate(latestRev);
                            break;
                        }
                        this.doImport();
                        this.doActivateBundle();
                        break;
                    }
                    if (RestUtil.Options.clean) {
                        this.activeRevision = RestUtil.getDeployedRevision(this.getProfile());
                        if (this.activeRevision.length() > 0) {
                            this.doDelete(this.activeRevision);
                            break;
                        }
                        logger.info("No active revision for " + this.getProfile().getEnvironment() + "environment. Nothing to delete");
                        break;
                    }
                    this.doImport();
                    if (RestUtil.Options.inactive) break;
                    this.doRefreshBundle();
                    break;
                }
                case deployinactive: {
                    logger.warn("Note: -Dbuild.option=deploy-inactive   is Deprecated, use -Dapigee.options=inactive instead");
                    this.doImport();
                    break;
                }
                case undeploy: {
                    logger.warn("Note: -Dbuild.option=undeploy is Deprecated, use -Dapigee.options=clean instead");
                    this.doDeactivae();
                    break;
                }
                case delete: {
                    this.activeRevision = RestUtil.getDeployedRevision(this.getProfile());
                    this.doDelete(this.activeRevision);
                    break;
                }
            }
            this.state = State.COMPLETE;
        }
        catch (MojoFailureException e) {
            this.processHelpfulErrorMessage((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.processHelpfulErrorMessage(e);
        }
        catch (Exception e) {
            this.processHelpfulErrorMessage(e);
        }
    }

    private void processHelpfulErrorMessage(Exception e) throws MojoExecutionException {
        if (this.state == State.IMPORTING) {
            logger.error(DEPLOYMENT_FAILED_MESSAGE);
        }
        if (e instanceof MojoExecutionException) {
            throw (MojoExecutionException)e;
        }
        throw new MojoExecutionException("", e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        inactive,
        force,
        validate,
        clean,
        update,
        override;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BUILDOPTIONS {
        NULL,
        deployinactive,
        undeploy,
        delete;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START,
        INIT,
        IMPORTING,
        DEACTIVATING,
        ACTIVATING,
        DELETING,
        COMPLETE;

    }
}

