/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.rest;

import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.testing.http.MockHttpContent;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.apigee.buildTools.enterprise4g.rest.FakeHostnameVerifier;
import io.apigee.buildTools.enterprise4g.rest.XTrustProvider;
import io.apigee.buildTools.enterprise4g.utils.PrintUtil;
import io.apigee.buildTools.enterprise4g.utils.ServerProfile;
import io.apigee.buildTools.enterprise4g.utils.StringToIntComparator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    static String versionRevision;
    static Logger logger;
    static Gson gson;
    public static final String STATE_UNDEPLOYED = "undeployed";
    public static final String STATE_DEPLOYED = "deployed";
    public static final String STATE_ERROR = "error";
    public static final String STATE_IMPORTED = "imported";
    static HttpRequestFactory REQUEST_FACTORY;

    public static void getRevision(ServerProfile profile) throws IOException {
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/"));
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
        restRequest.setHeaders(headers);
        logger.info(PrintUtil.formatRequest(restRequest));
        try {
            HttpResponse response = restRequest.execute();
            AppRevision apprev = (AppRevision)response.parseAs(AppRevision.class);
            Collections.sort(apprev.revision, new StringToIntComparator());
            RestUtil.setVersionRevision(apprev.revision.get(0));
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)apprev).toString()));
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
    }

    public static String getLatestRevision(ServerProfile profile) throws IOException {
        String revision = "";
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/"));
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
        restRequest.setHeaders(headers);
        logger.info(PrintUtil.formatRequest(restRequest));
        try {
            HttpResponse response = restRequest.execute();
            AppRevision apprev = (AppRevision)response.parseAs(AppRevision.class);
            Collections.sort(apprev.revision, new StringToIntComparator());
            revision = apprev.revision.get(0);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)apprev).toString()));
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
        return revision;
    }

    public static String getDeployedRevision(ServerProfile profile) throws IOException {
        BundleDeploymentConfig deployment1 = null;
        try {
            HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/deployments"));
            restRequest.setReadTimeout(0);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
            restRequest.setHeaders(headers);
            logger.debug(PrintUtil.formatRequest(restRequest));
            HttpResponse response = restRequest.execute();
            deployment1 = (BundleDeploymentConfig)response.parseAs(BundleDeploymentConfig.class);
            logger.debug(PrintUtil.formatResponse(response, gson.toJson((Object)deployment1).toString()));
            if (deployment1 != null) {
                for (Environment env : deployment1.environment) {
                    if (!env.name.equalsIgnoreCase(profile.getEnvironment())) continue;
                    return env.revision.get((int)0).name;
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return "";
    }

    public static String uploadBundle(ServerProfile profile, String bundleFile) throws IOException {
        FileContent fContent = new FileContent("application/octet-stream", new File(bundleFile));
        logger.debug("URL parameters API Version{}", (Object)profile.getApi_version());
        logger.debug("URL parameters URL {}", (Object)profile.getHostUrl());
        logger.debug("URL parameters Org{}", (Object)profile.getOrg());
        logger.debug("URL parameters App {}", (Object)profile.getApplication());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis?action=import&name=" + profile.getApplication();
        if (Options.validate) {
            importCmd = importCmd + "&validate=true";
        }
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)fContent);
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
        restRequest.setHeaders(headers);
        logger.info(PrintUtil.formatRequest(restRequest));
        try {
            HttpResponse response = restRequest.execute();
            AppConfig appconf = (AppConfig)response.parseAs(AppConfig.class);
            RestUtil.setVersionRevision(appconf.revision);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)appconf).toString()));
            if (Options.delay != 0L) {
                try {
                    logger.info("Delay of " + Options.delay + " milli second");
                    Thread.sleep(Options.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return RestUtil.getVersionRevision();
    }

    public static String updateBundle(ServerProfile profile, String bundleFile, String revision) throws IOException {
        FileContent fContent = new FileContent("application/octet-stream", new File(bundleFile));
        logger.debug("URL parameters API Version{}", (Object)profile.getApi_version());
        logger.debug("URL parameters URL {}", (Object)profile.getHostUrl());
        logger.debug("URL parameters Org{}", (Object)profile.getOrg());
        logger.debug("URL parameters App {}", (Object)profile.getApplication());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/revisions/" + revision + "?validate=true";
        if (Options.validate) {
            importCmd = importCmd + "&validate=true";
        }
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)fContent);
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
        restRequest.setHeaders(headers);
        logger.info(PrintUtil.formatRequest(restRequest));
        try {
            HttpResponse response = restRequest.execute();
            AppConfig appconf = (AppConfig)response.parseAs(AppConfig.class);
            RestUtil.setVersionRevision(appconf.revision);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)appconf).toString()));
            if (Options.delay != 0L) {
                try {
                    logger.info("Delay of " + Options.delay + " milli second");
                    Thread.sleep(Options.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return RestUtil.getVersionRevision();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deactivateBundle(ServerProfile profile) throws IOException {
        MockHttpContent content = new MockHttpContent();
        String existingRevision = "";
        BundleActivationConfig deployment1 = new BundleActivationConfig();
        try {
            existingRevision = RestUtil.getDeployedRevision(profile);
            if (existingRevision.length() > 0) {
                logger.info("De-activating Version: " + existingRevision + " For Env Profile: " + profile.getEnvironment());
                String undeployCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/apis/" + profile.getApplication() + "/revisions/" + existingRevision + "/deployments";
                HttpRequest undeployRestRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(undeployCmd));
                undeployRestRequest.setReadTimeout(0);
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept("application/json");
                headers.setContentType("application/x-www-form-urlencoded");
                headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
                undeployRestRequest.setHeaders(headers);
                HttpResponse response = null;
                logger.info(PrintUtil.formatRequest(undeployRestRequest));
                response = undeployRestRequest.execute();
                deployment1 = (BundleActivationConfig)response.parseAs(BundleActivationConfig.class);
                logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)deployment1).toString()));
                if (Options.delay != 0L) {
                    try {
                        logger.info("Delay of " + Options.delay + " milli second");
                        Thread.sleep(Options.delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                deployment1.state = STATE_UNDEPLOYED;
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
            deployment1.state = STATE_ERROR;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            deployment1.state = STATE_ERROR;
        }
        finally {
            if (Options.force) {
                String anyExistingRevision = "";
                try {
                    logger.info("Checking if any deployed version still exists for Env Profile: " + profile.getEnvironment());
                    anyExistingRevision = RestUtil.getDeployedRevision(profile);
                }
                catch (Exception e) {
                    logger.error("Application couldn't be undeployed :: " + anyExistingRevision);
                    deployment1.state = STATE_ERROR;
                }
                if (anyExistingRevision.length() > 0) {
                    logger.warn("Application couldn't be undeployed :: " + anyExistingRevision);
                    deployment1.state = STATE_ERROR;
                }
            }
        }
        return deployment1.state;
    }

    public static String refreshBundle(ServerProfile profile, String revision) throws IOException {
        String state = "";
        try {
            state = RestUtil.deactivateBundle(profile);
            if (!state.equals(STATE_UNDEPLOYED)) {
                throw new IOException("The bundle is not undeployed");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new IOException("Error in undeploying bundle");
        }
        logger.info("Activating Version: " + revision + " For Env Profile: " + profile.getEnvironment());
        return RestUtil.activateBundleRevision(profile, revision);
    }

    public static String activateBundleRevision(ServerProfile profile, String revision) throws IOException {
        String state = "";
        BundleActivationConfig deployment2 = new BundleActivationConfig();
        try {
            UrlEncodedContent urlEncodedContent = null;
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
            String deployCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/apis/" + profile.getApplication() + "/revisions/" + revision + "/deployments";
            if (Options.override) {
                GenericData data = new GenericData();
                data.set("override", (Object)"true");
                data.set("delay", (Object)"5");
                urlEncodedContent = new UrlEncodedContent((Object)data);
            }
            HttpRequest deployRestRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(deployCmd), urlEncodedContent);
            deployRestRequest.setReadTimeout(0);
            deployRestRequest.setHeaders(headers);
            HttpResponse response = null;
            logger.info(PrintUtil.formatRequest(deployRestRequest));
            response = deployRestRequest.execute();
            if (Options.override) {
                SeamLessDeploymentStatus deployment3 = (SeamLessDeploymentStatus)response.parseAs(SeamLessDeploymentStatus.class);
                for (BundleActivationConfig config : deployment3.environment) {
                    if (!config.environment.equalsIgnoreCase(profile.getEnvironment())) continue;
                    if (!config.state.equalsIgnoreCase(STATE_DEPLOYED)) {
                        logger.info("\nWaiting to assert bundle activation.....");
                        Thread.sleep(10L);
                        if (RestUtil.getDeployedRevision(profile).equalsIgnoreCase(revision)) {
                            logger.info("\nDeployed revision is: " + RestUtil.getVersionRevision());
                            return STATE_DEPLOYED;
                        }
                        logger.error("Deployment failed to activate");
                        throw new MojoExecutionException("Deployment failed: Bundle did not activate within expected time. Please check deployment status manually before trying again");
                    }
                    logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)deployment3).toString()));
                }
            }
            deployment2 = (BundleActivationConfig)response.parseAs(BundleActivationConfig.class);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)deployment2).toString()));
            logger.info("\nDeployed revision is: " + RestUtil.getVersionRevision());
            if (Options.delay != 0L) {
                try {
                    logger.debug("Delay of " + Options.delay + " milli second");
                    Thread.sleep(Options.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        return deployment2.state;
    }

    public static String deleteBundle(ServerProfile profile, String revision) throws IOException {
        String deployed_revision = "";
        try {
            deployed_revision = RestUtil.getDeployedRevision(profile);
        }
        catch (Exception e) {
            throw new IOException("Error fetching deployed revision");
        }
        if (deployed_revision.equals(revision)) {
            RestUtil.deactivateBundle(profile);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setContentType("application/octet-stream");
        headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
        HttpRequest deleteRestRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/revisions/" + revision));
        deleteRestRequest.setReadTimeout(0);
        deleteRestRequest.setHeaders(headers);
        HttpResponse response = null;
        logger.info(PrintUtil.formatRequest(deleteRestRequest));
        response = deleteRestRequest.execute();
        AppConfig deleteResponse = (AppConfig)response.parseAs(AppConfig.class);
        logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)deleteResponse).toString()));
        if (Options.delay != 0L) {
            try {
                logger.info("Delay of " + Options.delay + " milli second");
                Thread.sleep(Options.delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return deleteResponse.getRevision();
    }

    public static String getVersionRevision() {
        return versionRevision;
    }

    public static void setVersionRevision(String versionRevision) {
        RestUtil.versionRevision = versionRevision;
    }

    static {
        logger = LoggerFactory.getLogger(RestUtil.class);
        gson = new GsonBuilder().setPrettyPrinting().create();
        REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)JSON_FACTORY.createJsonObjectParser());
                XTrustProvider.install();
                FakeHostnameVerifier _hostnameVerifier = new FakeHostnameVerifier();
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((Object)_hostnameVerifier));
            }
        });
    }

    public static class AppConfig {
        @Key
        public ConfigVersion configurationVersion;
        @Key
        public String contextInfo;
        @Key
        public long createdAt;
        @Key
        public String createdBy;
        @Key
        public long lastModifiedAt;
        @Key
        public String lastModifiedBy;
        @Key
        public List<String> policies;
        @Key
        public List<String> proxyEndpoints;
        @Key
        public List<String> resources;
        @Key
        public String revision;
        @Key
        public List<String> targetEndpoints;
        @Key
        public List<String> targetServers;
        @Key
        public String type;

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }
    }

    public static class SeamLessDeploymentStatus {
        @Key
        public String aPIProxy;
        @Key
        public List<BundleActivationConfig> environment;
        @Key
        public String organization;
    }

    public static class BundleActivationConfig {
        @Key
        public String aPIProxy;
        @Key
        public Configuration configuration;
        @Key
        public String environment;
        @Key
        public String name;
        @Key
        public String organization;
        @Key
        public String revision;
        @Key
        public String state;
        @Key
        public List<Server> server;
    }

    public static class BundleDeploymentConfig {
        @Key
        public List<Environment> environment;
        @Key
        public String name;
        @Key
        public String organization;
    }

    public static class Environment {
        @Key
        public String name;
        @Key
        public List<Revision> revision;
    }

    public static class Revision {
        @Key
        public Configuration configuration;
        @Key
        public String name;
        @Key
        public List<Server> server;
        @Key
        public String state;
    }

    public static class Configuration {
        @Key
        public String basePath;
        @Key
        public List<String> steps;
    }

    public static class Server {
        @Key
        public String status;
        @Key
        public List<String> type;
        @Key
        public String uUID;
    }

    public static class ConfigVersion {
        @Key
        public int majorVersion;
        @Key
        public int minorVersion;
    }

    public static class AppRevision {
        @Key
        public String name;
        @Key
        public List<String> revision;
    }

    public static class Options {
        public static boolean force;
        public static boolean clean;
        public static boolean update;
        public static boolean inactive;
        public static boolean override;
        public static boolean validate;
        public static long delay;
        public static long override_delay;
    }
}

