/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.apigee.buildTools.enterprise4g.utils.ConfigTokens;
import io.apigee.buildTools.enterprise4g.utils.FileReader;
import io.apigee.buildTools.enterprise4g.utils.GitUtil;
import io.apigee.buildTools.enterprise4g.utils.XMLFileListUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PackageConfigurer {
    public static void configurePackage(String env, File configFile) throws Exception {
        StreamResult result;
        DOMSource source;
        ConfigTokens.Policy configTokens;
        Document xmlDoc;
        int i;
        Logger logger = LoggerFactory.getLogger(PackageConfigurer.class);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        XMLFileListUtil listFileUtil = new XMLFileListUtil();
        List<File> fileList = listFileUtil.getProxyFiles(configFile);
        FileReader fileutil = new FileReader();
        ConfigTokens conf = fileutil.getBundleConfigs(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getProxyFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getPolicyFiles(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getPolicyFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for policy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getTargetFiles(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getTargetFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for policy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getAPIProxyFiles(configFile);
        Document xmlDoc2 = fileutil.getXMLDocument(fileList.get(0));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expression = xpath.compile("/APIProxy/Description");
        NodeList nodes = (NodeList)expression.evaluate(xmlDoc2, XPathConstants.NODESET);
        if (nodes.item(0).hasChildNodes()) {
            nodes.item(0).setTextContent(expression.evaluate(xmlDoc2));
        } else {
            nodes.item(0).setTextContent(PackageConfigurer.getComment(fileList.get(0)));
        }
        DOMSource source2 = new DOMSource(xmlDoc2);
        StreamResult result2 = new StreamResult(fileList.get(0));
        transformer.transform(source2, result2);
    }

    public static Document replaceTokens(Document doc, ConfigTokens.Policy configTokens) throws XPathExpressionException, TransformerConfigurationException {
        Logger logger = LoggerFactory.getLogger(PackageConfigurer.class);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)configTokens);
        logger.info("============= to apply the following config tokens ================\n{}", (Object)json);
        try {
            for (int i = 0; i < configTokens.tokens.size(); ++i) {
                logger.debug("=============Checking for Xpath Expressions {}  ================\n", (Object)configTokens.tokens.get((int)i).xpath);
                XPathExpression expression = xpath.compile(configTokens.tokens.get((int)i).xpath);
                NodeList nodes = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                for (int j = 0; j < nodes.getLength(); ++j) {
                    if (!nodes.item(j).hasChildNodes()) continue;
                    logger.debug("=============Updated existing value {} to new value {} ================\n", (Object)nodes.item(j).getTextContent(), (Object)configTokens.tokens.get((int)i).value);
                    nodes.item(j).setTextContent(configTokens.tokens.get((int)i).value);
                }
            }
            return doc;
        }
        catch (Exception e) {
            logger.error("\n\n=============The Xpath Expressions in config.json are incorrect. Please check. ================\n\n{}", (Object)e.getMessage());
            throw (XPathExpressionException)e;
        }
    }

    protected static String getComment(File basePath) {
        try {
            String hostname = "unknown";
            String user = System.getProperty("user.name", "unknown");
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return user + " " + PackageConfigurer.getScmRevision(basePath) + " " + hostname;
        }
        catch (Throwable t) {
            return "";
        }
    }

    protected static String getScmRevision(File basePath) {
        String rev = null;
        try {
            GitUtil gu = new GitUtil(basePath);
            String tagName = gu.getTagNameForWorkspaceHeadRevision();
            rev = "git: ";
            rev = tagName == null ? rev + "" : rev + tagName + " - ";
            String revNum = gu.getWorkspaceHeadRevisionString();
            revNum = revNum.substring(0, Math.min(revNum.length(), 8));
            rev = rev + revNum;
        }
        catch (Throwable e) {
            rev = null;
        }
        if (rev == null) {
            rev = "git revision unknown";
        }
        return rev;
    }
}

