/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.utils;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

public class PrintUtil {
    public static String formatRequest(HttpRequest request) {
        String prettyRequest = "\n\n\nRequest prepared for the server \n **************************\n";
        prettyRequest = prettyRequest + request.getMethod() + "  " + request.getUrl();
        HttpHeaders headers = request.getHeaders();
        Set tempheadersmap = headers.keySet();
        Iterator iter = tempheadersmap.iterator();
        while (iter.hasNext()) {
            try {
                String headerkey = (String)iter.next();
                if (!headerkey.trim().equalsIgnoreCase("Authorization")) {
                    String headervalue = "" + headers.get((Object)headerkey);
                    prettyRequest = prettyRequest + "\n" + headerkey + ": " + headervalue;
                    continue;
                }
                prettyRequest = prettyRequest + "\n" + "authorization" + ": " + "Basic [Not shown in log]";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (request.getMethod().compareTo((Enum)HttpMethod.POST) == 0 && request.getContent() != null && request.getContent().getType() != null) {
                prettyRequest = prettyRequest + "\n" + "content-type" + ": " + request.getContent().getType();
                if (!request.getContent().getType().contains("octet")) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    request.getContent().writeTo((OutputStream)out);
                    prettyRequest = prettyRequest + "\n [Request body]\n" + out.toString();
                } else {
                    prettyRequest = prettyRequest + "\n [Request body contains data, not shown] \n";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prettyRequest;
    }

    public static String formatResponse(HttpResponse response, String body) {
        String prettyString = "\n\n\nResponse returned by the server \n **************************\n";
        prettyString = prettyString + response.getStatusCode() + "  " + response.getStatusMessage();
        HttpHeaders headers = response.getHeaders();
        Set tempheadersmap = headers.keySet();
        Iterator iter = tempheadersmap.iterator();
        while (iter.hasNext()) {
            try {
                String headerkey = (String)iter.next();
                if (headerkey.trim().equalsIgnoreCase("Authorization")) continue;
                String headervalue = "" + headers.get((Object)headerkey);
                prettyString = prettyString + "\n" + headerkey + ": " + headervalue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        prettyString = prettyString + "\n" + body;
        return prettyString;
    }
}

