/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.utils;

import io.apigee.buildTools.enterprise4g.utils.ExtFileNameFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFileListUtil {
    public List<File> getProxyFiles(File configFile) throws IOException {
        ArrayList<File> fileNames = new ArrayList();
        String sDirectory = configFile.getParent() + File.separator + "target" + File.separator + "apiproxy" + File.separator + "proxies";
        fileNames = this.getXMLFiles(sDirectory);
        return fileNames;
    }

    public List<File> getPolicyFiles(File configFile) throws IOException {
        ArrayList<File> fileNames = new ArrayList();
        String sDirectory = configFile.getParent() + File.separator + "target" + File.separator + "apiproxy" + File.separator + "policies";
        fileNames = this.getXMLFiles(sDirectory);
        List<File> stepNames = this.getStepFiles(configFile);
        if (stepNames != null) {
            fileNames.addAll(stepNames);
        }
        return fileNames;
    }

    private List<File> getStepFiles(File configFile) throws IOException {
        ArrayList<File> fileNames = new ArrayList();
        String sDirectory = configFile.getParent() + File.separator + "target" + File.separator + "apiproxy" + File.separator + "stepdefinitions";
        fileNames = this.getXMLFiles(sDirectory);
        return fileNames;
    }

    public List<File> getTargetFiles(File configFile) throws IOException {
        ArrayList<File> fileNames = new ArrayList();
        String sDirectory = configFile.getParent() + File.separator + "target" + File.separator + "apiproxy" + File.separator + "targets";
        fileNames = this.getXMLFiles(sDirectory);
        return fileNames;
    }

    public List<File> getAPIProxyFiles(File configFile) throws IOException {
        ArrayList<File> fileNames = new ArrayList();
        String sDirectory = configFile.getParent() + File.separator + "target" + File.separator + "apiproxy";
        fileNames = this.getXMLFiles(sDirectory);
        return fileNames;
    }

    private List<File> getXMLFiles(String sFolder) {
        ArrayList<File> aList = new ArrayList<File>();
        Logger logger = LoggerFactory.getLogger(XMLFileListUtil.class);
        try {
            File folder = new File(sFolder);
            ExtFileNameFilter xmlFilter = new ExtFileNameFilter("xml");
            logger.debug("=============Searching for XML files in the following directory ================\n{}", (Object)folder.getAbsolutePath());
            aList = new ArrayList<File>(Arrays.asList(folder.listFiles(xmlFilter)));
            logger.debug("=============Nuber of files found is================\n{}", (Object)aList.size());
        }
        catch (Exception e) {
            logger.debug("=============Error Encountered in Searching files [" + sFolder + "]================\n" + e);
        }
        return aList;
    }
}

