/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.mgmtapi.sdk.client;

import com.apigee.mgmtapi.sdk.core.AppConfig;
import com.apigee.mgmtapi.sdk.service.FileService;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class MgmtAPIClient {
    private static final Logger logger = LogManager.getLogger(MgmtAPIClient.class);

    public com.apigee.mgmtapi.sdk.model.AccessToken getAccessToken(String username, String password) throws Exception {
        Environment env = this.getConfigProperties();
        if (env == null) {
            logger.error("Config file missing");
            throw new Exception("Config file missing");
        }
        return this.getAccessToken(env.getProperty("mgmt.login.url"), env.getProperty("mgmt.login.client.id"), env.getProperty("mgmt.login.client.secret"), username, password);
    }

    public com.apigee.mgmtapi.sdk.model.AccessToken getAccessToken(String username, String password, String mfa) throws Exception {
        Environment env = this.getConfigProperties();
        if (env == null) {
            logger.error("Config file missing");
            throw new Exception("Config file missing");
        }
        if (mfa == null || mfa.equals("")) {
            logger.error("mfa cannot be empty");
            throw new Exception("mfa cannot be empty");
        }
        return this.getAccessToken(env.getProperty("mgmt.login.mfa.url") + mfa, env.getProperty("mgmt.login.client.id"), env.getProperty("mgmt.login.client.secret"), username, password);
    }

    public com.apigee.mgmtapi.sdk.model.AccessToken getAccessToken(String url, String clientId, String client_secret, String username, String password, String mfa) throws Exception {
        return this.getAccessToken(url + "?mfa_token=" + mfa, clientId, client_secret, username, password);
    }

    public com.apigee.mgmtapi.sdk.model.AccessToken getAccessToken(String url, String clientId, String client_secret, String username, String password) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        com.apigee.mgmtapi.sdk.model.AccessToken token = new com.apigee.mgmtapi.sdk.model.AccessToken();
        ResponseEntity result = null;
        try {
            headers.add("Authorization", "Basic " + new String(Base64.encode((byte[])(clientId + ":" + client_secret).getBytes()), Charset.forName("UTF-8")));
            headers.add("Content-Type", "application/x-www-form-urlencoded");
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"username", (Object)username);
            map.add((Object)"password", (Object)password);
            map.add((Object)"grant_type", (Object)"password");
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            result = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().equals((Object)HttpStatus.OK)) {
                Gson gson = new Gson();
                token = (com.apigee.mgmtapi.sdk.model.AccessToken)gson.fromJson((String)result.getBody(), com.apigee.mgmtapi.sdk.model.AccessToken.class);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
        return token;
    }

    public com.apigee.mgmtapi.sdk.model.AccessToken getAccessTokenFromRefreshToken(String url, String clientId, String client_secret, String refreshToken) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        com.apigee.mgmtapi.sdk.model.AccessToken token = new com.apigee.mgmtapi.sdk.model.AccessToken();
        ResponseEntity result = null;
        try {
            headers.add("Authorization", "Basic " + new String(Base64.encode((byte[])(clientId + ":" + client_secret).getBytes()), Charset.forName("UTF-8")));
            headers.add("Content-Type", "application/x-www-form-urlencoded");
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"refresh_token", (Object)refreshToken);
            map.add((Object)"grant_type", (Object)"refresh_token");
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            result = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().equals((Object)HttpStatus.OK)) {
                Gson gson = new Gson();
                token = (com.apigee.mgmtapi.sdk.model.AccessToken)gson.fromJson((String)result.getBody(), com.apigee.mgmtapi.sdk.model.AccessToken.class);
            }
        }
        catch (Exception e) {
            logger.error("Refresh Token could be invalid or expired: " + e.getMessage());
            throw e;
        }
        return token;
    }

    public Environment getConfigProperties() {
        FileService service = null;
        try {
            if (System.getProperty("configFile.path") == null || System.getProperty("configFile.path").equalsIgnoreCase("")) {
                return null;
            }
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{AppConfig.class});
            service = (FileService)context.getBean("fileService");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return service.getEnvironment();
    }

    public String getGoogleAccessToken(File serviceAccountJSON) throws Exception {
        try {
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(serviceAccountJSON)).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
            credentials.refreshIfExpired();
            AccessToken token = credentials.getAccessToken();
            return token.getTokenValue();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }
}

