/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.mavenplugin;

import io.apigee.buildTools.enterprise4g.mavenplugin.GatewayAbstractMojo;
import io.apigee.buildTools.enterprise4g.rest.RestUtil;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends GatewayAbstractMojo {
    public static final String DEPLOYMENT_FAILED_MESSAGE = "\n\n\n* * * * * * * * * * *\n\nThis deployment could have failed for a variety of reasons.\n\n\n\n* * * * * * * * * * *\n\n\n";
    static Logger logger = LogManager.getLogger(DeployMojo.class);
    State state = State.START;
    String activeRevision = "";
    String bundleRevision = "";
    String revisionInArg = "";
    BUILDOPTIONS buildOption;

    public void init() throws IOException, MojoFailureException, Exception {
        try {
            String options = "";
            this.state = State.INIT;
            long delay = 0L;
            if (this.getBuildOption() != null) {
                String opt = this.getBuildOption();
                opt = opt.replace("-", "");
                this.buildOption = BUILDOPTIONS.valueOf(opt);
            } else {
                this.buildOption = BUILDOPTIONS.valueOf("NULL");
            }
            if (this.getDelay() != null) {
                RestUtil.Options.delay = delay = this.getDelay().longValue();
            }
            if (this.getOverridedelay() != null) {
                RestUtil.Options.override_delay = delay = this.getOverridedelay().longValue();
            }
            if ((options = super.getOptions()) != null) {
                String[] opts;
                block8: for (String opt : opts = options.split(",")) {
                    opt = opt.replace("-", "");
                    switch (OPTIONS.valueOf(opt)) {
                        case override: {
                            RestUtil.Options.override = true;
                            continue block8;
                        }
                        case async: {
                            RestUtil.Options.override = true;
                            RestUtil.Options.async = true;
                            continue block8;
                        }
                        case clean: {
                            RestUtil.Options.clean = true;
                            this.buildOption = BUILDOPTIONS.valueOf("clean");
                            continue block8;
                        }
                    }
                }
            } else {
                RestUtil.Options.override = true;
            }
            logger.info("\n\n=============Initializing Maven Deployment================\n\n");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void doImport() throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Importing App================\n\n");
            this.state = State.IMPORTING;
            RestUtil restUtil = new RestUtil(super.getProfile());
            this.bundleRevision = restUtil.uploadBundle(super.getProfile(), super.getApplicationBundlePath());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void doUpdate(String revision) throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Updating App================\n\n");
            this.state = State.IMPORTING;
            RestUtil restUtil = new RestUtil(super.getProfile());
            this.bundleRevision = restUtil.updateBundle(super.getProfile(), super.getApplicationBundlePath(), revision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void doDeactivae() throws IOException, MojoFailureException, Exception {
        try {
            logger.info("\n\n=============Deactivating App================\n\n");
            this.state = State.DEACTIVATING;
            RestUtil restUtil = new RestUtil(super.getProfile());
            restUtil.deactivateBundle(super.getProfile());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void doRefreshBundle() throws IOException, MojoFailureException {
        try {
            logger.info("\n\n=============Refresh Bundle================\n\n");
            this.state = State.ACTIVATING;
            RestUtil restUtil = new RestUtil(super.getProfile());
            restUtil.refreshBundle(super.getProfile(), this.bundleRevision);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void doActivateBundle() throws IOException, MojoFailureException, InterruptedException {
        try {
            logger.info("\n\n=============Activating Bundle================\n\n");
            this.state = State.ACTIVATING;
            RestUtil restUtil = new RestUtil(super.getProfile());
            String revision = restUtil.activateBundleRevision(super.getProfile(), this.bundleRevision);
            if (RestUtil.Options.async) {
                return;
            }
            boolean deployed = false;
            while (!deployed) {
                deployed = restUtil.getDeploymentStateForRevision(super.getProfile(), revision);
                Thread.sleep(5000L);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        Thread.sleep(5000L);
    }

    public void doDelete() throws IOException, MojoFailureException, Exception {
        try {
            RestUtil restUtil = new RestUtil(this.getProfile());
            String status = restUtil.deactivateBundle(this.getProfile());
            if (status == null) {
                logger.info("No bundle to delete");
                return;
            }
            logger.info("\n\n=============Deleting bundle================\n\n");
            this.state = State.DELETING;
            restUtil.deleteBundle(this.getProfile());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        try {
            this.init();
            switch (this.buildOption) {
                case NULL: {
                    this.doImport();
                    this.doActivateBundle();
                    break;
                }
                case clean: {
                    this.doDelete();
                    break;
                }
            }
            this.state = State.COMPLETE;
        }
        catch (MojoFailureException e) {
            this.processHelpfulErrorMessage((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.processHelpfulErrorMessage(e);
        }
        catch (Exception e) {
            this.processHelpfulErrorMessage(e);
        }
    }

    private void processHelpfulErrorMessage(Exception e) throws MojoExecutionException {
        if (this.state == State.IMPORTING) {
            logger.error(DEPLOYMENT_FAILED_MESSAGE);
        }
        if (e instanceof MojoExecutionException) {
            throw (MojoExecutionException)e;
        }
        throw new MojoExecutionException("", e);
    }

    static enum OPTIONS {
        override,
        async,
        clean;

    }

    static enum BUILDOPTIONS {
        NULL,
        clean;

    }

    static enum State {
        START,
        INIT,
        IMPORTING,
        DEACTIVATING,
        ACTIVATING,
        DELETING,
        COMPLETE;

    }
}

