/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.mavenplugin;

import io.apigee.buildTools.enterprise4g.utils.ServerProfile;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class GatewayAbstractMojo
extends AbstractMojo
implements Contextualizable {
    static Logger logger = LogManager.getLogger(GatewayAbstractMojo.class);
    protected static final Pattern URL_PARSE_REGEX = Pattern.compile("^(http[s]?)://([^:/?#]*).*$");
    protected MavenProject project;
    protected MavenSession session;
    protected Settings settings;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    protected SettingsDecrypter settingsDecrypter;
    private File buildDirectory;
    private File baseDirectory;
    private String projectName;
    private String projectVersion;
    private String artifactId;
    private String id;
    private String hostURL;
    private String tokenURL;
    private String mfaToken;
    private String authType;
    private String deploymentEnv;
    private String apiVersion;
    private String apiType;
    private String orgName;
    private String bearer;
    private String refresh;
    private String clientid;
    private String clientsecret;
    private String userName;
    private String password;
    private String buildOption;
    private String options;
    private Long delay;
    private Long overridedelay;
    private Long revision;
    private String serviceAccountFilePath;
    private String googleTokenEmail;
    private boolean skip = false;
    public ServerProfile buildProfile;

    public ServerProfile getProfile() {
        this.buildProfile = new ServerProfile();
        this.buildProfile.setOrg(this.orgName);
        this.buildProfile.setApplication(this.projectName);
        this.buildProfile.setApi_version(this.apiVersion);
        this.buildProfile.setApi_type(this.apiType);
        this.buildProfile.setHostUrl(this.hostURL);
        this.buildProfile.setTokenUrl(this.tokenURL);
        this.buildProfile.setMFAToken(this.mfaToken);
        this.buildProfile.setAuthType(this.authType);
        this.buildProfile.setEnvironment(this.deploymentEnv);
        this.buildProfile.setBearerToken(this.bearer);
        this.buildProfile.setRefreshToken(this.refresh);
        this.buildProfile.setCredential_user(this.userName);
        this.buildProfile.setCredential_pwd(this.password);
        this.buildProfile.setClientId(this.clientid);
        this.buildProfile.setClientSecret(this.clientsecret);
        this.buildProfile.setProfileId(this.id);
        this.buildProfile.setOptions(this.options);
        this.buildProfile.setDelay(this.delay);
        this.buildProfile.setOverridedelay(this.overridedelay);
        this.buildProfile.setRevision(this.revision);
        this.buildProfile.setServiceAccountJSONFile(this.serviceAccountFilePath);
        this.buildProfile.setGoogleTokenEmail(this.googleTokenEmail);
        Proxy mavenProxy = this.getProxy(this.settings, this.hostURL);
        if (mavenProxy != null) {
            logger.info("set proxy to " + mavenProxy.getHost() + ":" + mavenProxy.getPort());
            HttpClientBuilder builder = HttpClientBuilder.create();
            HttpHost proxy = new HttpHost(mavenProxy.getHost(), mavenProxy.getPort());
            if (StringUtils.isNotBlank((CharSequence)mavenProxy.getNonProxyHosts())) {
                // empty if block
            }
            if (StringUtils.isNotBlank((CharSequence)mavenProxy.getUsername()) && StringUtils.isNotBlank((CharSequence)mavenProxy.getPassword())) {
                logger.debug("set proxy credentials");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(mavenProxy.getHost(), mavenProxy.getPort()), (Credentials)new UsernamePasswordCredentials(mavenProxy.getUsername(), mavenProxy.getPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                this.buildProfile.setProxyUsername(mavenProxy.getUsername());
                this.buildProfile.setProxyPassword(mavenProxy.getPassword());
            }
            builder.setProxy(proxy);
            this.buildProfile.setApacheHttpClient((HttpClient)builder.build());
            this.buildProfile.setHasProxy(true);
            this.buildProfile.setProxyProtocol(mavenProxy.getProtocol());
            this.buildProfile.setProxyServer(mavenProxy.getHost());
            this.buildProfile.setProxyPort(mavenProxy.getPort());
        }
        return this.buildProfile;
    }

    public void setProfile(ServerProfile profile) {
        this.buildProfile = profile;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public String getBuildDirectory() {
        return this.buildDirectory.getAbsolutePath();
    }

    public String getApplicationBundlePath() {
        return this.baseDirectory + File.separator + "target" + File.separator + this.projectName + "-" + this.projectVersion + ".zip";
    }

    public String getBaseDirectoryPath() {
        return this.baseDirectory.getAbsolutePath();
    }

    public String getBuildOption() {
        return this.buildOption;
    }

    public void setBuildOption(String buildOption) {
        this.buildOption = buildOption;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public Long getOverridedelay() {
        return this.overridedelay;
    }

    public void setOverridedelay(Long overridedelay) {
        this.overridedelay = overridedelay;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        if (this.container.hasComponent(SettingsDecrypter.class)) {
            try {
                this.settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            }
            catch (ComponentLookupException e) {
                logger.warn("Failed to lookup build in maven component session decrypter.", (Throwable)e);
            }
        }
    }

    protected Proxy getProxy(Settings settings, String host) {
        if (settings == null) {
            return null;
        }
        List proxies = settings.getProxies();
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        String protocol = "https";
        String hostname = host;
        Matcher matcher = URL_PARSE_REGEX.matcher(host);
        if (matcher.matches()) {
            protocol = matcher.group(1);
            hostname = matcher.group(2);
        }
        for (Proxy proxy : proxies) {
            if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol()) || this.matchNonProxy(proxy, hostname)) continue;
            if (this.settingsDecrypter != null) {
                return this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy)).getProxy();
            }
            logger.warn("Maven did not inject SettingsDecrypter, proxy may contain an encrypted password, which cannot be used to setup the REST client.");
            return proxy;
        }
        return null;
    }

    protected boolean matchNonProxy(Proxy proxy, String hostname) {
        String[] nonProxies;
        String nonProxyHosts = proxy.getNonProxyHosts();
        if (null != nonProxyHosts && null != (nonProxies = nonProxyHosts.split("(,)|(;)|(\\|)"))) {
            for (String nonProxyHost : nonProxies) {
                if (null != nonProxyHost && nonProxyHost.contains("*")) {
                    int pos = nonProxyHost.indexOf(42);
                    String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                    String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                    if (!StringUtils.isBlank((CharSequence)nonProxyHostPrefix) && hostname.startsWith(nonProxyHostPrefix) && StringUtils.isBlank((CharSequence)nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isBlank((CharSequence)nonProxyHostPrefix) && !StringUtils.isBlank((CharSequence)nonProxyHostSuffix) && hostname.endsWith(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isBlank((CharSequence)nonProxyHostPrefix) || !hostname.startsWith(nonProxyHostPrefix) || StringUtils.isBlank((CharSequence)nonProxyHostSuffix) || !hostname.endsWith(nonProxyHostSuffix)) continue;
                    return true;
                }
                if (!hostname.equals(nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }
}

