/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.rest;

import com.apigee.mgmtapi.sdk.client.MgmtAPIClient;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.apigee.buildTools.enterprise4g.rest.FakeHostnameVerifier;
import io.apigee.buildTools.enterprise4g.rest.XTrustProvider;
import io.apigee.buildTools.enterprise4g.utils.PrintUtil;
import io.apigee.buildTools.enterprise4g.utils.ServerProfile;
import io.apigee.buildTools.enterprise4g.utils.StringToIntComparator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestUtil {
    private static HttpRequestFactory REQUEST_FACTORY;
    private static HttpRequestFactory APACHE_REQUEST_FACTORY;
    static final HttpTransport HTTP_TRANSPORT;
    static final JsonFactory JSON_FACTORY;
    static String versionRevision;
    static Logger logger;
    static Gson gson;
    public static final String STATE_UNDEPLOYED = "undeployed";
    public static final String STATE_DEPLOYED = "deployed";
    public static final String STATE_ERROR = "error";
    public static final String STATE_IMPORTED = "imported";
    static String accessToken;
    private ServerProfile profile;

    public ServerProfile getProfile() {
        return this.profile;
    }

    public RestUtil(ServerProfile profile) {
        ApacheHttpTransport apacheHttpTransport;
        NetHttpTransport httpTransport;
        this.profile = profile;
        if (profile.getApacheHttpClient() != null) {
            httpTransport = new ApacheHttpTransport(profile.getApacheHttpClient());
            apacheHttpTransport = new ApacheHttpTransport(profile.getApacheHttpClient());
        } else {
            httpTransport = new NetHttpTransport();
            apacheHttpTransport = new ApacheHttpTransport();
        }
        REQUEST_FACTORY = httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)JSON_FACTORY.createJsonObjectParser());
                XTrustProvider.install();
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((Object)new FakeHostnameVerifier()));
            }
        });
        APACHE_REQUEST_FACTORY = apacheHttpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)JSON_FACTORY.createJsonObjectParser());
                XTrustProvider.install();
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((Object)new FakeHostnameVerifier()));
            }
        });
    }

    public void initMfa(ServerProfile profile) throws IOException {
        if (accessToken == null) {
            logger.info("=============Initialising MFA================");
            HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/"));
            restRequest.setReadTimeout(0);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            restRequest.setHeaders(headers);
            try {
                HttpResponse response = this.executeAPI(profile, restRequest);
                logger.info("=============MFA Initialised================");
            }
            catch (HttpResponseException e) {
                logger.error(e.getMessage());
                throw e;
            }
        }
    }

    public void getRevision(ServerProfile profile) throws IOException {
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/"));
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        restRequest.setHeaders(headers);
        try {
            HttpResponse response = this.executeAPI(profile, restRequest);
            AppRevision apprev = (AppRevision)response.parseAs(AppRevision.class);
            Collections.sort(apprev.revision, new StringToIntComparator());
            this.setVersionRevision(apprev.revision.get(0));
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)apprev).toString()));
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
    }

    public String getLatestRevision(ServerProfile profile) throws IOException {
        String revision = "";
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + profile.getApplication() + "/"));
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        restRequest.setHeaders(headers);
        try {
            HttpResponse response = this.executeAPI(profile, restRequest);
            AppRevision apprev = (AppRevision)response.parseAs(AppRevision.class);
            Collections.sort(apprev.revision, new StringToIntComparator());
            revision = apprev.revision.get(0);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)apprev).toString()));
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
        return revision;
    }

    public boolean getDeploymentStateForRevision(ServerProfile profile, String revision) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.getDeploymentStateForRevision(profile, "sharedflows", revision);
        }
        return this.getDeploymentStateForRevision(profile, "apis", revision);
    }

    public boolean getDeploymentStateForRevision(ServerProfile profile, String type, String revision) throws IOException {
        DeploymentStatus deploymentStatus = null;
        boolean deployed = false;
        try {
            logger.info("Getting Deployment Info for Revision: " + revision);
            HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + type + "/" + profile.getApplication() + "/revisions/" + revision + "/deployments"));
            restRequest.setReadTimeout(0);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            restRequest.setHeaders(headers);
            HttpResponse response = this.executeAPI(profile, restRequest);
            deploymentStatus = (DeploymentStatus)response.parseAs(DeploymentStatus.class);
            if (deploymentStatus != null && deploymentStatus.state != null && deploymentStatus.state.equalsIgnoreCase("ERROR")) {
                if (deploymentStatus.errors != null && deploymentStatus.errors.size() > 0) {
                    String errorString = deploymentStatus.errors.stream().map(Error::getMessage).collect(Collectors.joining("\n"));
                    throw new IOException("Deployment error: " + errorString);
                }
            } else {
                deployed = deploymentStatus != null && deploymentStatus.state != null && deploymentStatus.state.equalsIgnoreCase("READY");
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.debug("returning deployed status: " + deployed);
        return deployed;
    }

    public String getDeployedRevision(ServerProfile profile) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.getDeployedRevision(profile, "sharedflows");
        }
        return this.getDeployedRevision(profile, "apis");
    }

    public String getDeployedRevision(ServerProfile profile, String type) throws IOException {
        BundleDeploymentConfig bundleDeploymentConfig = null;
        try {
            HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + type + "/" + profile.getApplication() + "/deployments"));
            restRequest.setReadTimeout(0);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            restRequest.setHeaders(headers);
            HttpResponse response = this.executeAPI(profile, restRequest);
            bundleDeploymentConfig = (BundleDeploymentConfig)response.parseAs(BundleDeploymentConfig.class);
            logger.debug(PrintUtil.formatResponse(response, gson.toJson((Object)bundleDeploymentConfig).toString()));
            if (bundleDeploymentConfig != null && bundleDeploymentConfig.deployments != null && bundleDeploymentConfig.deployments.size() > 0) {
                for (Deployment deployment : bundleDeploymentConfig.deployments) {
                    if (!deployment.environment.equalsIgnoreCase(profile.getEnvironment())) continue;
                    logger.info("Deployed revision: " + deployment.revision);
                    return deployment.revision;
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return "";
    }

    public String uploadBundle(ServerProfile profile, String bundleFile) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.uploadBundle(profile, bundleFile, "sharedflows");
        }
        return this.uploadBundle(profile, bundleFile, "apis");
    }

    public String uploadBundle(ServerProfile profile, String bundleFile, String type) throws IOException {
        MultipartContent content = new MultipartContent().setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
        FileContent fContent = new FileContent("application/octet-stream", new File(bundleFile));
        MultipartContent.Part part = new MultipartContent.Part((HttpContent)fContent);
        part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"content\"; file=\"%s\"", new File(bundleFile).getName())));
        content.addPart(part);
        logger.debug("URL parameters API Version{}", (Object)profile.getApi_version());
        logger.debug("URL parameters URL {}", (Object)profile.getHostUrl());
        logger.debug("URL parameters Org{}", (Object)profile.getOrg());
        logger.debug("URL parameters App {}", (Object)profile.getApplication());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + type + "?action=import&name=" + profile.getApplication();
        if (Options.validate) {
            importCmd = importCmd + "&validate=true";
        }
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        restRequest.setHeaders(headers);
        try {
            HttpResponse response = this.executeAPI(profile, restRequest);
            AppConfig appconf = (AppConfig)response.parseAs(AppConfig.class);
            this.setVersionRevision(appconf.revision);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)appconf).toString()));
            if (Options.delay != 0L) {
                try {
                    logger.info("Delay of " + Options.delay + " milli second");
                    Thread.sleep(Options.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return this.getVersionRevision();
    }

    public String updateBundle(ServerProfile profile, String bundleFile, String revision) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.updateBundle(profile, bundleFile, revision, "sharedflows");
        }
        return this.updateBundle(profile, bundleFile, revision, "apis");
    }

    public String updateBundle(ServerProfile profile, String bundleFile, String revision, String type) throws IOException {
        FileContent fContent = new FileContent("application/octet-stream", new File(bundleFile));
        logger.debug("URL parameters API Version{}", (Object)profile.getApi_version());
        logger.debug("URL parameters URL {}", (Object)profile.getHostUrl());
        logger.debug("URL parameters Org{}", (Object)profile.getOrg());
        logger.debug("URL parameters App {}", (Object)profile.getApplication());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + type + "/" + profile.getApplication() + "/revisions/" + revision + "?validate=true";
        if (Options.validate) {
            importCmd = importCmd + "&validate=true";
        }
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)fContent);
        restRequest.setReadTimeout(0);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        restRequest.setHeaders(headers);
        try {
            HttpResponse response = this.executeAPI(profile, restRequest);
            AppConfig appconf = (AppConfig)response.parseAs(AppConfig.class);
            this.setVersionRevision(appconf.revision);
            logger.info(PrintUtil.formatResponse(response, gson.toJson((Object)appconf).toString()));
            if (Options.delay != 0L) {
                try {
                    logger.info("Delay of " + Options.delay + " milli second");
                    Thread.sleep(Options.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (HttpResponseException e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return this.getVersionRevision();
    }

    public String deactivateBundle(ServerProfile profile) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.deactivateBundle(profile, "sharedflows");
        }
        return this.deactivateBundle(profile, "apis");
    }

    public String deactivateBundle(ServerProfile profile, String type) throws IOException {
        block7: {
            String existingRevision = "";
            try {
                existingRevision = this.getDeployedRevision(profile);
                if (existingRevision.length() > 0) {
                    logger.info("De-activating Version: " + existingRevision + " For Env Profile: " + profile.getEnvironment());
                    String undeployCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + type + "/" + profile.getApplication() + "/revisions/" + existingRevision + "/deployments";
                    HttpRequest undeployRestRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(undeployCmd));
                    undeployRestRequest.setReadTimeout(0);
                    HttpHeaders headers = new HttpHeaders();
                    headers.setAccept("application/json");
                    undeployRestRequest.setHeaders(headers);
                    HttpResponse response = null;
                    response = this.executeAPI(profile, undeployRestRequest);
                    if (Options.delay != 0L) {
                        try {
                            logger.info("Delay of " + Options.delay + " milli second");
                            Thread.sleep(Options.delay);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    break block7;
                }
                logger.info("No active revisions to deactivate");
                return null;
            }
            catch (HttpResponseException e) {
                logger.error(e.getMessage());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return STATE_UNDEPLOYED;
    }

    public String refreshBundle(ServerProfile profile, String revision) throws IOException {
        String state = "";
        try {
            state = this.deactivateBundle(profile);
            if (!state.equals(STATE_UNDEPLOYED)) {
                throw new IOException("The bundle is not undeployed");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new IOException("Error in undeploying bundle");
        }
        logger.info("Activating Version: " + revision + " For Env Profile: " + profile.getEnvironment());
        return this.activateBundleRevision(profile, revision);
    }

    public String activateBundleRevision(ServerProfile profile, String revision) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.activateBundleRevision(profile, revision, "sharedflows");
        }
        return this.activateBundleRevision(profile, revision, "apis");
    }

    public String activateBundleRevision(ServerProfile profile, String revision, String type) throws IOException {
        HttpResponse response = null;
        DeploymentStatus deploymentStatus = null;
        try {
            GenericData data;
            UrlEncodedContent urlEncodedContent = null;
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/json");
            String deployCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + type + "/" + profile.getApplication() + "/revisions/" + revision + "/deployments";
            if (profile.getGoogleTokenEmail() != null && !profile.getGoogleTokenEmail().equals("")) {
                deployCmd = deployCmd + "?serviceAccount=" + profile.getGoogleTokenEmail();
            }
            if (Options.override) {
                data = new GenericData();
                data.set("override", (Object)"true");
                if (Options.override_delay != 0L) {
                    data.set("delay", (Object)Options.override_delay);
                }
                urlEncodedContent = new UrlEncodedContent((Object)data);
            } else {
                data = new GenericData();
                data.set("override", (Object)"false");
                urlEncodedContent = new UrlEncodedContent((Object)data);
            }
            HttpRequest deployRestRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(deployCmd), (HttpContent)urlEncodedContent);
            deployRestRequest.setReadTimeout(0);
            deployRestRequest.setHeaders(headers);
            response = this.executeAPI(profile, deployRestRequest);
            String responseString = response.parseAsString();
            deploymentStatus = (DeploymentStatus)new Gson().fromJson(responseString, DeploymentStatus.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        return deploymentStatus.revision;
    }

    public String deleteBundle(ServerProfile profile) throws IOException {
        if (profile.getApi_type() != null && profile.getApi_type().equalsIgnoreCase("sharedflow")) {
            return this.deleteBundle(profile, "sharedflows");
        }
        return this.deleteBundle(profile, "apis");
    }

    public String deleteBundle(ServerProfile profile, String type) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept("application/json");
        headers.setContentType("application/octet-stream");
        HttpRequest deleteRestRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + type + "/" + profile.getApplication()));
        deleteRestRequest.setReadTimeout(0);
        deleteRestRequest.setHeaders(headers);
        this.executeAPI(profile, deleteRestRequest);
        return null;
    }

    public String getVersionRevision() {
        return versionRevision;
    }

    public void setVersionRevision(String versionRevision) {
        RestUtil.versionRevision = versionRevision;
    }

    private HttpResponse executeAPI(ServerProfile profile, HttpRequest request) throws IOException {
        HttpHeaders headers = request.getHeaders();
        try {
            MgmtAPIClient client = new MgmtAPIClient();
            if (profile.getBearerToken() != null && !profile.getBearerToken().equalsIgnoreCase("")) {
                logger.info("Using the bearer token");
                accessToken = profile.getBearerToken();
            } else if (profile.getServiceAccountJSONFile() != null && !profile.getServiceAccountJSONFile().equalsIgnoreCase("")) {
                logger.info("Using the service account file to generate a token");
                File serviceAccountJSON = new File(profile.getServiceAccountJSONFile());
                accessToken = client.getGoogleAccessToken(serviceAccountJSON);
            } else {
                logger.error("Service Account file or bearer token is missing");
                throw new IOException("Service Account file or bearer token is missing");
            }
            logger.debug("**Access Token** " + accessToken);
            headers.setAuthorization("Bearer " + accessToken);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        headers.set("X-GOOG-API-FORMAT-VERSION", (Object)2);
        logger.info(PrintUtil.formatRequest(request));
        return request.execute();
    }

    static {
        HTTP_TRANSPORT = new NetHttpTransport();
        JSON_FACTORY = new JacksonFactory();
        logger = LogManager.getLogger(RestUtil.class);
        gson = new GsonBuilder().setPrettyPrinting().create();
        accessToken = null;
    }

    public static class AppConfig {
        @Key
        public ConfigVersion configurationVersion;
        @Key
        public String contextInfo;
        @Key
        public long createdAt;
        @Key
        public String createdBy;
        @Key
        public long lastModifiedAt;
        @Key
        public String lastModifiedBy;
        @Key
        public List<String> policies;
        @Key
        public List<String> proxyEndpoints;
        @Key
        public List<String> resources;
        @Key
        public String revision;
        @Key
        public List<String> targetEndpoints;
        @Key
        public List<String> targetServers;
        @Key
        public String type;

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }
    }

    public static class Error {
        @Key
        public Integer code;
        @Key
        public String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class PodStatus {
        @Key
        public String podName;
        @Key
        public String appVersion;
        @Key
        public String podStatus;
        @Key
        public String podStatusTime;
        @Key
        public String deploymentStatusTime;
        @Key
        public String deploymentTime;
        @Key
        public String deploymentStatus;
        @Key
        public String statusCode;
        @Key
        public String statusCodeDetails;
    }

    public static class DeploymentStatus {
        @Key
        public String apiProxy;
        @Key
        public String sharedFlow;
        @Key
        public String environment;
        @Key
        public String revision;
        @Key
        public String deployStartTime;
        @Key
        public String basePath;
        @Key
        public String state;
        @Key
        public List<PodStatus> pods;
        @Key
        public List<Error> errors;
        @Key
        public String organization;
    }

    public static class SeamLessDeploymentStatus {
        @Key
        public String aPIProxy;
        @Key
        public String sharedFlow;
        @Key
        public List<BundleActivationConfig> environment;
        @Key
        public String organization;
    }

    public static class BundleActivationConfig {
        @Key
        public String aPIProxy;
        @Key
        public String sharedFlow;
        @Key
        public Configuration configuration;
        @Key
        public String environment;
        @Key
        public String name;
        @Key
        public String organization;
        @Key
        public String revision;
        @Key
        public String state;
        @Key
        public List<Server> server;
    }

    public static class BundleDeploymentConfig {
        @Key
        public List<Deployment> deployments;
    }

    public static class Deployment {
        @Key
        public String environment;
        @Key
        public String apiProxy;
        @Key
        public String revision;
        @Key
        public String deployStartTime;
        @Key
        public String basePath;
    }

    public static class Environment {
        @Key
        public String name;
        @Key
        public List<Revision> revision;
    }

    public static class Revision {
        @Key
        public Configuration configuration;
        @Key
        public String name;
        @Key
        public List<Server> server;
        @Key
        public String state;
    }

    public static class Configuration {
        @Key
        public String basePath;
        @Key
        public List<String> steps;
    }

    public static class Server {
        @Key
        public String status;
        @Key
        public List<String> type;
        @Key
        public String uUID;
    }

    public static class ConfigVersion {
        @Key
        public int majorVersion;
        @Key
        public int minorVersion;
    }

    public static class AppRevision {
        @Key
        public String name;
        @Key
        public List<String> revision;
    }

    public static class Options {
        public static boolean force;
        public static boolean clean;
        public static boolean update;
        public static boolean inactive;
        public static boolean override;
        public static boolean async;
        public static boolean validate;
        public static long delay;
        public static long override_delay;
    }
}

