/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.utils;

import io.apigee.buildTools.enterprise4g.utils.AstException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

public class GitUtil {
    Git git;

    public GitUtil(File f) {
        try {
            File workspace = GitUtil.findWorkspaceRoot(f);
            if (workspace == null) {
                throw new IllegalStateException("Does not appear to be a Git workspace: " + f.getCanonicalPath());
            }
            Repository r = ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(GitUtil.findWorkspaceRoot(f))).build();
            this.git = new Git(r);
        }
        catch (IOException e) {
            throw new AstException(e);
        }
    }

    public Git getGit() {
        return this.git;
    }

    public static File findWorkspaceRoot(File f) {
        if (f == null) {
            return null;
        }
        File gitDir = new File(f, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            return f;
        }
        return GitUtil.findWorkspaceRoot(f.getParentFile());
    }

    public String getWorkspaceHeadRevisionString() {
        Ref headRef = this.getWorkspaceHeadRevision();
        String headRevision = headRef.getObjectId().getName();
        return headRevision;
    }

    public Ref getWorkspaceHeadRevision() {
        Map refs = this.git.getRepository().getAllRefs();
        Ref headRef = (Ref)refs.get("HEAD");
        return headRef;
    }

    public String getTagNameForWorkspaceHeadRevision() {
        String headRevision = this.getWorkspaceHeadRevisionString();
        Map tags = this.git.getRepository().getAllRefs();
        for (Ref tagRef : tags.values()) {
            int lastSlashIndex;
            String tagName = tagRef.getName();
            ObjectId obj = tagRef.getPeeledObjectId();
            if (obj == null) {
                obj = tagRef.getObjectId();
            }
            if (!headRevision.equals(obj.getName()) || !tagName.contains("/tags/") || (lastSlashIndex = tagName.lastIndexOf("/")) <= 0) continue;
            tagName = tagName.substring(lastSlashIndex + 1);
            return tagName;
        }
        return null;
    }
}

