/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.buildTools.enterprise4g.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.apigee.buildTools.enterprise4g.utils.ConfigTokens;
import io.apigee.buildTools.enterprise4g.utils.FileReader;
import io.apigee.buildTools.enterprise4g.utils.GitUtil;
import io.apigee.buildTools.enterprise4g.utils.XMLFileListUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageConfigurer {
    public static void configurePackage(String env, File configFile) throws Exception {
        StreamResult result;
        DOMSource source;
        ConfigTokens.Policy configTokens;
        Document xmlDoc;
        int i;
        Logger logger = LogManager.getLogger(PackageConfigurer.class);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        XMLFileListUtil listFileUtil = new XMLFileListUtil();
        List<File> fileList = listFileUtil.getProxyFiles(configFile);
        FileReader fileutil = new FileReader();
        ConfigTokens conf = fileutil.getBundleConfigs(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getProxyFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                result.setSystemId(fileList.get(i).getAbsolutePath());
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getPolicyFiles(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getPolicyFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for policy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                result.setSystemId(fileList.get(i).getAbsolutePath());
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getTargetFiles(configFile);
        for (i = 0; i < fileList.size(); ++i) {
            xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                configTokens = conf.getConfigbyEnv(env).getTargetFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for policy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                source = new DOMSource(xmlDoc);
                result = new StreamResult(fileList.get(i));
                result.setSystemId(fileList.get(i).getAbsolutePath());
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getAPIProxyFiles(configFile);
        if (fileList != null && fileList.size() > 0) {
            Document xmlDoc2 = fileutil.getXMLDocument(fileList.get(0));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expression = xpath.compile("/APIProxy/Description");
            Node node = (Node)expression.evaluate(xmlDoc2, XPathConstants.NODE);
            if (node == null) {
                Element root = xmlDoc2.getDocumentElement();
                node = xmlDoc2.createElement("Description");
                root.appendChild(node);
            }
            if (node.hasChildNodes()) {
                node.setTextContent(expression.evaluate(xmlDoc2));
            } else {
                node.setTextContent(PackageConfigurer.getComment(fileList.get(0)));
            }
            DOMSource source2 = new DOMSource(xmlDoc2);
            StreamResult result2 = new StreamResult(fileList.get(0));
            result2.setSystemId(fileList.get(0).getAbsolutePath());
            transformer.transform(source2, result2);
        }
    }

    public static void configureSharedFlowPackage(String env, File configFile) throws Exception {
        Logger logger = LogManager.getLogger(PackageConfigurer.class);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        XMLFileListUtil listFileUtil = new XMLFileListUtil();
        FileReader fileutil = new FileReader();
        ConfigTokens conf = fileutil.getBundleConfigs(configFile);
        List<File> fileList = listFileUtil.getPolicyFiles(configFile, "sharedflowbundle");
        for (int i = 0; i < fileList.size(); ++i) {
            Document xmlDoc = fileutil.getXMLDocument(fileList.get(i));
            try {
                ConfigTokens.Policy configTokens = conf.getConfigbyEnv(env).getPolicyFileNameMatch(fileList.get(i).getName());
                if (configTokens == null) continue;
                logger.info("=============Replacing config tokens for Environment {}, for policy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                xmlDoc = PackageConfigurer.replaceTokens(xmlDoc, configTokens);
                DOMSource source = new DOMSource(xmlDoc);
                StreamResult result = new StreamResult(fileList.get(i));
                result.setSystemId(fileList.get(i).getAbsolutePath());
                transformer.transform(source, result);
                continue;
            }
            catch (Exception e) {
                logger.error("\n\n=============No config tokens found for Environment {}, for proxy file name {}================\n", (Object)env, (Object)fileList.get(i).getName());
                throw e;
            }
        }
        fileList = listFileUtil.getSharedFlowFiles(configFile);
        if (fileList != null && fileList.size() > 0) {
            Document xmlDoc = fileutil.getXMLDocument(fileList.get(0));
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expression = xpath.compile("/SharedFlowBundle/Description");
            Node node = (Node)expression.evaluate(xmlDoc, XPathConstants.NODE);
            if (node == null) {
                Element root = xmlDoc.getDocumentElement();
                node = xmlDoc.createElement("Description");
                root.appendChild(node);
            }
            if (node.hasChildNodes()) {
                node.setTextContent(expression.evaluate(xmlDoc));
            } else {
                node.setTextContent(PackageConfigurer.getComment(fileList.get(0)));
            }
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(fileList.get(0));
            result.setSystemId(fileList.get(0).getAbsolutePath());
            transformer.transform(source, result);
        }
    }

    public static Document replaceTokens(Document doc, ConfigTokens.Policy configTokens) throws XPathExpressionException, TransformerConfigurationException {
        Logger logger = LogManager.getLogger(PackageConfigurer.class);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)configTokens);
        logger.info("============= to apply the following config tokens ================\n{}", (Object)json);
        try {
            for (int i = 0; i < configTokens.tokens.size(); ++i) {
                logger.debug("=============Checking for Xpath Expressions {}  ================\n", (Object)configTokens.tokens.get((int)i).xpath);
                XPathExpression expression = xpath.compile(configTokens.tokens.get((int)i).xpath);
                NodeList nodes = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
                for (int j = 0; j < nodes.getLength(); ++j) {
                    if (nodes.item(j).getNodeName() == null || nodes.item(j).getNodeName().equals("")) continue;
                    logger.debug("=============Updated existing value {} to new value {} ================\n", (Object)nodes.item(j).getTextContent(), (Object)configTokens.tokens.get((int)i).value);
                    nodes.item(j).setTextContent(configTokens.tokens.get((int)i).value);
                }
            }
            return doc;
        }
        catch (Exception e) {
            logger.error("\n\n=============The Xpath Expressions in config.json are incorrect. Please check. ================\n\n{}", (Object)e.getMessage());
            throw (XPathExpressionException)e;
        }
    }

    protected static String getComment(File basePath) {
        try {
            String hostname = "unknown";
            String user = System.getProperty("user.name", "unknown");
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return user + " " + PackageConfigurer.getScmRevision(basePath) + " " + hostname;
        }
        catch (Throwable t) {
            return "";
        }
    }

    protected static String getScmRevision(File basePath) {
        String rev = null;
        try {
            GitUtil gu = new GitUtil(basePath);
            String tagName = gu.getTagNameForWorkspaceHeadRevision();
            rev = "git: ";
            rev = tagName == null ? rev + "" : rev + tagName + " - ";
            String revNum = gu.getWorkspaceHeadRevisionString();
            revNum = revNum.substring(0, Math.min(revNum.length(), 8));
            rev = rev + revNum;
        }
        catch (Throwable e) {
            rev = null;
        }
        if (rev == null) {
            rev = "git revision unknown";
        }
        return rev;
    }
}

