/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import io.apiman.common.config.options.AbstractOptions;
import java.util.Map;

public class BasicAuthOptions
extends AbstractOptions {
    public static final String PREFIX = "basic-auth.";
    public static final String BASIC_USERNAME = "basic-auth.username";
    public static final String BASIC_PASSWORD = "basic-auth.password";
    public static final String BASIC_REQUIRE_SSL = "basic-auth.requireSSL";
    private String username;
    private String password;
    private boolean requireSSL;

    public BasicAuthOptions(Map<String, String> options) {
        super(options);
    }

    @Override
    protected void parse(Map<String, String> options) {
        this.setUsername(BasicAuthOptions.getVar(options, BASIC_USERNAME));
        this.setPassword(BasicAuthOptions.getVar(options, BASIC_PASSWORD));
        this.setRequireSSL(BasicAuthOptions.parseBool(options, BASIC_REQUIRE_SSL, true));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRequireSSL() {
        return this.requireSSL;
    }

    public void setRequireSSL(boolean requireSSL) {
        this.requireSSL = requireSSL;
    }
}

