/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config.options;

import io.apiman.common.config.options.AbstractOptions;
import java.util.Map;

public class TLSOptions
extends AbstractOptions {
    public static final String PREFIX = "tls.";
    public static final String TLS_TRUSTSTORE = "tls.trustStore";
    public static final String TLS_TRUSTSTOREPASSWORD = "tls.trustStorePassword";
    public static final String TLS_KEYSTORE = "tls.keyStore";
    public static final String TLS_KEYSTOREPASSWORD = "tls.keystorePassword";
    public static final String TLS_KEYALIASES = "tls.keyAliases";
    public static final String TLS_KEYPASSWORD = "tls.keyPassword";
    public static final String TLS_ALLOWEDPROTOCOLS = "tls.allowedProtocols";
    public static final String TLS_ALLOWEDCIPHERS = "tls.allowedCiphers";
    public static final String TLS_ALLOWANYHOST = "tls.allowAnyHost";
    public static final String TLS_ALLOWSELFSIGNED = "tls.allowSelfSigned";
    public static final String TLS_DEVMODE = "tls.devMode";
    private String trustStore;
    private String trustStorePassword;
    private String clientKeyStore;
    private String keyStorePassword;
    private String keyPassword;
    private String[] allowedProtocols;
    private String[] allowedCiphers;
    private boolean allowAnyHost;
    private boolean trustSelfSigned;
    private boolean devMode;
    private String[] keyAliases;

    public TLSOptions(Map<String, String> options) {
        super(options);
    }

    @Override
    protected void parse(Map<String, String> options) {
        this.trustStore = TLSOptions.getVar(options, TLS_TRUSTSTORE);
        this.trustStorePassword = TLSOptions.getVar(options, TLS_TRUSTSTOREPASSWORD);
        this.clientKeyStore = TLSOptions.getVar(options, TLS_KEYSTORE);
        this.keyStorePassword = TLSOptions.getVar(options, TLS_KEYSTOREPASSWORD);
        this.keyAliases = TLSOptions.split(TLSOptions.getVar(options, TLS_KEYALIASES), ',');
        this.keyPassword = TLSOptions.getVar(options, TLS_KEYPASSWORD);
        this.allowedProtocols = TLSOptions.split(TLSOptions.getVar(options, TLS_ALLOWEDPROTOCOLS), ',');
        this.allowedCiphers = TLSOptions.split(TLSOptions.getVar(options, TLS_ALLOWEDCIPHERS), ',');
        this.allowAnyHost = TLSOptions.parseBool(options, TLS_ALLOWANYHOST);
        this.trustSelfSigned = TLSOptions.parseBool(options, TLS_ALLOWSELFSIGNED);
        this.devMode = TLSOptions.parseBool(options, TLS_DEVMODE);
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getkeyStore() {
        return this.clientKeyStore;
    }

    public void setClientKeyStore(String clientKeyStore) {
        this.clientKeyStore = clientKeyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String[] getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public void setAllowedProtocols(String[] allowedProtocols) {
        this.allowedProtocols = allowedProtocols;
    }

    public String[] getAllowedCiphers() {
        return this.allowedCiphers;
    }

    public void setAllowedCiphers(String[] allowedCiphers) {
        this.allowedCiphers = allowedCiphers;
    }

    public boolean isAllowAnyHost() {
        return this.allowAnyHost;
    }

    public void setAllowAnyHost(boolean allowAnyHost) {
        this.allowAnyHost = allowAnyHost;
    }

    public boolean isTrustSelfSigned() {
        return this.trustSelfSigned;
    }

    public void setAllowSelfSigned(boolean allowSelfSigned) {
        this.trustSelfSigned = allowSelfSigned;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public String[] getKeyAliases() {
        return this.keyAliases;
    }

    public void setKeyAliases(String[] keyAliases) {
        this.keyAliases = keyAliases;
    }
}

