/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.servlet;

import io.apiman.common.auth.AuthPrincipal;
import io.apiman.common.auth.AuthToken;
import io.apiman.common.auth.AuthTokenUtil;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class AuthenticationFilter
implements Filter {
    private String realm;
    private boolean signatureRequired;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;

    public void init(FilterConfig config) throws ServletException {
        String parameter = config.getInitParameter("realm");
        this.realm = parameter != null && parameter.trim().length() > 0 ? parameter : this.defaultRealm();
        parameter = config.getInitParameter("signatureRequired");
        this.signatureRequired = parameter != null && parameter.trim().length() > 0 ? Boolean.parseBoolean(parameter) : this.defaultSignatureRequired();
        parameter = config.getInitParameter("keystorePath");
        this.keystorePath = parameter != null && parameter.trim().length() > 0 ? parameter : this.defaultKeystorePath();
        parameter = config.getInitParameter("keystorePassword");
        this.keystorePassword = parameter != null && parameter.trim().length() > 0 ? parameter : this.defaultKeystorePassword();
        parameter = config.getInitParameter("keyAlias");
        this.keyAlias = parameter != null && parameter.trim().length() > 0 ? parameter : this.defaultKeyAlias();
        parameter = config.getInitParameter("keyPassword");
        this.keyPassword = parameter != null && parameter.trim().length() > 0 ? parameter : this.defaultKeyPassword();
    }

    protected String defaultKeystorePassword() {
        return null;
    }

    protected String defaultKeyAlias() {
        return null;
    }

    protected String defaultKeyPassword() {
        return null;
    }

    protected String defaultKeystorePath() {
        return null;
    }

    protected boolean defaultSignatureRequired() {
        return false;
    }

    protected boolean defaultWrapRequest() {
        return false;
    }

    protected Set<String> defaultAllowedIssuers() {
        return Collections.emptySet();
    }

    protected String defaultRealm() {
        return "apiman";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            this.sendAuthResponse((HttpServletResponse)response);
        } else if (authHeader.toUpperCase().startsWith("BASIC")) {
            Creds credentials = this.parseAuthorizationBasic(authHeader);
            if (credentials == null) {
                this.sendAuthResponse((HttpServletResponse)response);
            } else {
                this.doBasicAuth(credentials, req, (HttpServletResponse)response, chain);
            }
        } else if (authHeader.toUpperCase().startsWith("AUTH-TOKEN")) {
            AuthToken token = this.parseAuthorizationToken(authHeader);
            if (token == null) {
                this.sendAuthResponse((HttpServletResponse)response);
            } else {
                this.doTokenAuth(token, req, (HttpServletResponse)response, chain);
            }
        }
    }

    protected void doBasicAuth(Creds credentials, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (!credentials.username.equals(request.getRemoteUser())) {
                if (request.getRemoteUser() != null) {
                    request.logout();
                    request.login(credentials.username, credentials.password);
                } else {
                    request.login(credentials.username, credentials.password);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendAuthResponse(response);
            return;
        }
        this.doFilterChain((ServletRequest)request, (ServletResponse)response, chain, null);
    }

    protected void doTokenAuth(AuthToken token, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        AuthPrincipal principal = new AuthPrincipal(token.getPrincipal());
        principal.addRoles(token.getRoles());
        this.doFilterChain((ServletRequest)request, (ServletResponse)response, chain, principal);
    }

    protected void doFilterChain(ServletRequest request, ServletResponse response, FilterChain chain, AuthPrincipal principal) throws IOException, ServletException {
        if (principal == null) {
            chain.doFilter(request, response);
        } else {
            HttpServletRequest hsr = null;
            hsr = this.wrapTheRequest(request, principal);
            chain.doFilter((ServletRequest)hsr, response);
        }
    }

    private HttpServletRequest wrapTheRequest(ServletRequest request, final AuthPrincipal principal) {
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return principal.getRoles().contains(role);
            }

            public String getRemoteUser() {
                return principal.getName();
            }
        };
        return wrapper;
    }

    private Creds parseAuthorizationBasic(String authHeader) {
        String userpassEncoded = authHeader.substring(6);
        String data = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)userpassEncoded));
        int sepIdx = data.indexOf(58);
        if (sepIdx > 0) {
            String username = data.substring(0, sepIdx);
            String password = data.substring(sepIdx + 1);
            return new Creds(username, password);
        }
        return new Creds(data, null);
    }

    private AuthToken parseAuthorizationToken(String authHeader) {
        try {
            String tokenEncoded = authHeader.substring(11);
            return AuthTokenUtil.consumeToken((String)tokenEncoded);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void sendAuthResponse(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", String.format("BASIC realm=\"%1$s\"", this.realm));
        response.sendError(401);
    }

    public void destroy() {
    }

    protected static class Creds {
        public String username;
        public String password;

        public Creds(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

