/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.distro.db;

import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.util.ManagerTestUtils;
import io.apiman.test.common.util.TestPlanRunner;
import io.apiman.test.common.util.TestUtil;
import java.io.File;

public class CreateH2Database {
    protected ManagerApiTestServer testServer = new ManagerApiTestServer();
    private final boolean USE_PROXY = false;
    private final int PROXY_PORT = 7071;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CreateH2Database ch2d = new CreateH2Database();
        ch2d.setup();
        ch2d.startServer();
        try {
            ch2d.create();
        }
        finally {
            ch2d.stopServer();
        }
    }

    protected void startServer() {
        try {
            this.testServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void stopServer() {
        try {
            this.testServer.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void runTestPlan(String planPath, ClassLoader classLoader) {
        String baseApiUrl = "http://localhost:" + this.getTestServerPort() + this.getBaseApiContext();
        TestPlanRunner runner = new TestPlanRunner(baseApiUrl);
        this.configureSystemProperties();
        runner.runTestPlan(planPath, classLoader);
    }

    protected String getBaseApiContext() {
        return System.getProperty("apiman.junit.server-api-context", "/apiman");
    }

    protected int getTestServerPort() {
        String spPort = System.getProperty("apiman.junit.server-port");
        if (spPort != null) {
            return Integer.parseInt(spPort);
        }
        return this.testServer.serverPort();
    }

    private void configureSystemProperties() {
        System.setProperty("apiman.test.gateway.endpoint", "http://localhost:" + this.getTestServerPort() + "/mock-gateway");
        System.setProperty("apiman.test.gateway.username", "admin");
        System.setProperty("apiman.test.gateway.password", "admin");
        System.setProperty("apiman.manager.require-auto-granted-org", "false");
    }

    public void setup() throws Exception {
        String outputDir = System.getProperty("apiman.test.h2-output-dir");
        if (outputDir == null) {
            File targetClassesDir = new File("target/classes").getAbsoluteFile();
            if (!targetClassesDir.exists()) {
                targetClassesDir.mkdirs();
            }
            outputDir = targetClassesDir.toString();
        }
        System.out.println("------------------------------------------------");
        System.out.println("Setting H2 db output path: " + outputDir);
        System.out.println("------------------------------------------------");
        System.setProperty("apiman.test.h2-output-dir", outputDir);
        System.setProperty("apiman.test.admin-user-only", "true");
        this.setTestType();
    }

    protected void setTestType() {
        ManagerTestUtils.setTestType((ManagerTestUtils.TestType)ManagerTestUtils.TestType.jpa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        try {
            TestUtil.setProperty((String)"apiman.suite.api-username", (String)"admin");
            TestUtil.setProperty((String)"apiman.suite.api-password", (String)"admin");
            TestUtil.setProperty((String)"apiman.suite.gateway-config-endpoint", (String)"https://localhost:8443/apiman-gateway-api");
            TestUtil.setProperty((String)"apiman.suite.gateway-config-username", (String)"apimanager");
            TestUtil.setProperty((String)"apiman.suite.gateway-config-password", (String)"apiman123!");
            this.runTestPlan("scripts/api-manager-init-testPlan.xml", CreateH2Database.class.getClassLoader());
        }
        finally {
            System.clearProperty("apiman.test.admin-user-only");
            System.clearProperty("apiman.test.h2-output-dir");
        }
    }
}

