/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.api.rest.impl.mappers;

import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.api.rest.impl.mappers.GatewayApiErrorBean;
import io.apiman.gateway.engine.beans.exceptions.AbstractEngineException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.output.StringBuilderWriter;

@Provider
public class RestExceptionMapper
implements ExceptionMapper<AbstractEngineException> {
    public Response toResponse(AbstractEngineException data) {
        int errorCode = 500;
        if (data instanceof NotAuthorizedException) {
            errorCode = 403;
        }
        GatewayApiErrorBean error = new GatewayApiErrorBean();
        error.setErrorType(data.getClass().getSimpleName());
        error.setMessage(data.getMessage());
        error.setStacktrace(this.getStackTrace(data));
        Response.ResponseBuilder builder = Response.status((int)errorCode).header("X-API-Gateway-Error", (Object)"true");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.entity((Object)error).build();
    }

    private String getStackTrace(AbstractEngineException data) {
        StringBuilderWriter writer = new StringBuilderWriter();
        data.printStackTrace(new PrintWriter((Writer)writer));
        return writer.getBuilder().toString();
    }
}

