/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.api.rest.impl;

import io.apiman.gateway.api.rest.contract.IServiceResource;
import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.api.rest.impl.AbstractResourceImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceEndpoint;
import io.apiman.gateway.engine.beans.exceptions.AbstractEngineException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;

public class ServiceResourceImpl
extends AbstractResourceImpl
implements IServiceResource {
    public void publish(Service service) throws PublishingException, NotAuthorizedException {
        final HashSet errorHolder = new HashSet();
        final CountDownLatch latch = new CountDownLatch(1);
        this.getEngine().getRegistry().publishService(service, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    errorHolder.add(result.getError());
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!errorHolder.isEmpty()) {
            Throwable error = (Throwable)errorHolder.iterator().next();
            if (error instanceof AbstractEngineException) {
                throw (AbstractEngineException)error;
            }
            throw new RuntimeException(error);
        }
    }

    public void retire(String organizationId, String serviceId, String version) throws RegistrationException, NotAuthorizedException {
        final HashSet errorHolder = new HashSet();
        final CountDownLatch latch = new CountDownLatch(1);
        Service service = new Service();
        service.setOrganizationId(organizationId);
        service.setServiceId(serviceId);
        service.setVersion(version);
        this.getEngine().getRegistry().retireService(service, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    errorHolder.add(result.getError());
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!errorHolder.isEmpty()) {
            Throwable error = (Throwable)errorHolder.iterator().next();
            if (error instanceof AbstractEngineException) {
                throw (AbstractEngineException)error;
            }
            throw new RuntimeException(error);
        }
    }

    public ServiceEndpoint getServiceEndpoint(String organizationId, String serviceId, String version) throws NotAuthorizedException {
        return this.getPlatform().getServiceEndpoint(organizationId, serviceId, version);
    }
}

