/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.threescale;

import io.apiman.common.config.options.AbstractOptions;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.Version;
import io.apiman.gateway.engine.async.AsyncInitialize;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.impl.InMemoryRegistry;
import io.apiman.gateway.engine.threescale.beans.Auth3ScaleBean;
import io.apiman.gateway.engine.threescale.beans.BackendConfiguration;
import io.apiman.gateway.engine.threescale.beans.ProxyConfigRoot;
import io.apiman.gateway.engine.threescale.beans.RateLimitingStrategy;
import io.apiman.gateway.engine.threescale.beans.Service;
import io.apiman.gateway.engine.threescale.beans.ServicesRoot;
import io.apiman.gateway.engine.threescale.fetchers.AccessTokenResourceFetcher;
import io.apiman.gateway.engine.vertx.polling.PolicyConfigLoader;
import io.apiman.gateway.platforms.vertx3.common.verticles.Json;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.DecodeException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ThreeScaleImmutableRegistry
extends InMemoryRegistry
implements AsyncInitialize {
    private static volatile OneShotURILoader INSTANCE;
    private Vertx vertx;
    private Map<String, String> options;

    public ThreeScaleImmutableRegistry(Vertx vertx, IEngineConfig vxConfig, Map<String, String> options) {
        this.vertx = vertx;
        this.options = options;
    }

    public ThreeScaleImmutableRegistry(Map<String, String> options) {
        this(Vertx.vertx(), null, options);
    }

    public void initialize(IAsyncResultHandler<Void> resultHandler) {
        this.getURILoader(this.vertx, this.options).subscribe(this, resultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OneShotURILoader getURILoader(Vertx vertx, Map<String, String> options) {
        if (INSTANCE != null) return INSTANCE;
        Class<ThreeScaleImmutableRegistry> clazz = ThreeScaleImmutableRegistry.class;
        synchronized (ThreeScaleImmutableRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new OneShotURILoader(vertx, options);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void reloadData(IAsyncHandler<Void> doneHandler) {
        INSTANCE.reload(doneHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<ThreeScaleImmutableRegistry> clazz = ThreeScaleImmutableRegistry.class;
        synchronized (ThreeScaleImmutableRegistry.class) {
            INSTANCE = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void publishApi(Api api, IAsyncResultHandler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public void retireApi(Api api, IAsyncResultHandler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public void registerClient(Client client, IAsyncResultHandler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public void unregisterClient(Client client, IAsyncResultHandler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    protected void publishApiInternal(Api api, IAsyncResultHandler<Void> handler) {
        super.publishApi(api, handler);
    }

    protected void registerClientInternal(Client client, IAsyncResultHandler<Void> handler) {
        super.registerClient(client, handler);
    }

    private static final class OneShotURILoader {
        private Vertx vertx;
        private URI policyConfigUri;
        private Map<String, String> config;
        private IAsyncHandler<Void> reloadHandler;
        private List<IAsyncResultHandler<Void>> failureHandlers = new ArrayList<IAsyncResultHandler<Void>>();
        private Deque<ThreeScaleImmutableRegistry> awaiting = new ArrayDeque<ThreeScaleImmutableRegistry>();
        private List<ThreeScaleImmutableRegistry> allRegistries = new ArrayList<ThreeScaleImmutableRegistry>();
        private List<Api> policyConfigApis = Collections.emptyList();
        private boolean dataProcessed = false;
        private List<Auth3ScaleBean> configs = new ArrayList<Auth3ScaleBean>();
        private List<Client> clients = new ArrayList<Client>();
        private List<Api> apis = new ArrayList<Api>();
        private Logger log = LoggerFactory.getLogger(OneShotURILoader.class);
        private final String defaultOrgName;
        private final String defaultVersion;
        private final RateLimitingStrategy strategy;
        private final URI apiUri;
        private final String environment;
        private final String backendEndpoint;

        public OneShotURILoader(Vertx vertx, Map<String, String> config) {
            this.config = config;
            this.vertx = vertx;
            this.defaultOrgName = config.getOrDefault("defaultOrgName", "apiman");
            this.defaultVersion = config.getOrDefault("defaultVersion", "1.0");
            this.strategy = RateLimitingStrategy.valueOfOrDefault(config.get("strategy"), RateLimitingStrategy.STANDARD);
            this.apiUri = URI.create(this.requireOpt("apiEndpoint", "apiEndpoint is required in configuration"));
            this.environment = config.getOrDefault("environment", "production");
            this.backendEndpoint = config.getOrDefault("backendEndpoint", "https://su1.3scale.net:443");
            if (config.containsKey("policyConfig.overlayUri")) {
                this.policyConfigUri = URI.create(config.get("policyConfig.overlayUri"));
            }
            this.fetchResource();
        }

        private String requireOpt(String key, String errorMsg) {
            Arguments.require((boolean)this.config.containsKey(key), (String)errorMsg);
            return this.config.get(key);
        }

        public synchronized void reload(IAsyncHandler<Void> reloadHandler) {
            this.reloadHandler = reloadHandler;
            this.awaiting.addAll(this.allRegistries);
            this.apis.clear();
            this.clients.clear();
            this.failureHandlers.clear();
            this.allRegistries.stream().map(InMemoryRegistry::getMap).forEach(Map::clear);
            this.dataProcessed = false;
            this.fetchResource();
        }

        private void fetchResource() {
            this.log.debug((Object)"Fetching 3scale services...");
            this.getServicesRoot((Handler<ServicesRoot>)((Handler)servicesRoot -> {
                List<Service> services = servicesRoot.getServices();
                List sids = services.stream().map(service -> service.getService().getId()).collect(Collectors.toList());
                List configFutures = sids.stream().map(this::getConfig).collect(Collectors.toList());
                if (this.policyConfigUri != null) {
                    configFutures.add(this.fetchPolicyConfig());
                }
                CompositeFuture.all(configFutures).setHandler(result -> {
                    if (result.succeeded()) {
                        this.processData();
                    } else {
                        this.failAll(result.cause());
                    }
                });
            }));
        }

        private Future<List<Api>> fetchPolicyConfig() {
            this.log.debug((Object)"Loading policy configuration from {0}...", new Object[]{this.policyConfigUri});
            Future apiResultFuture = Future.future();
            Map filteredConfig = AbstractOptions.getSubmap(this.config, (String)"policyConfig.");
            new PolicyConfigLoader(this.vertx, this.policyConfigUri, filteredConfig).setApiResultHandler(apis -> {
                this.policyConfigApis = apis;
                apiResultFuture.complete();
            }).setExceptionHandler(arg_0 -> ((Future)apiResultFuture).fail(arg_0)).load();
            return apiResultFuture;
        }

        private Future getConfig(long id) {
            Future future = Future.future();
            String path = String.format("/admin/api/services/%d/proxy/configs/%s/latest.json", id, this.environment);
            new AccessTokenResourceFetcher(this.vertx, this.config, this.joinPath(path)).exceptionHandler((Handler<Throwable>)((Handler)arg_0 -> ((Future)future).fail(arg_0))).fetch((Handler<Buffer>)((Handler)buffer -> {
                if (buffer.length() > 0) {
                    ProxyConfigRoot pc = (ProxyConfigRoot)Json.decodeValue((String)buffer.toString(), ProxyConfigRoot.class);
                    this.log.debug((Object)"Received Proxy Config: {0}", new Object[]{pc});
                    Auth3ScaleBean bean = new Auth3ScaleBean().setThreescaleConfig(pc).setDefaultOrg(this.defaultOrgName).setDefaultVersion(this.defaultVersion).setRateLimitingStrategy(this.strategy).setBackendEndpoint(this.backendEndpoint);
                    this.configs.add(bean);
                }
                future.complete();
            }));
            return future;
        }

        private void getServicesRoot(Handler<ServicesRoot> resultHandler) {
            new AccessTokenResourceFetcher(this.vertx, this.config, this.joinPath("/admin/api/services.json")).exceptionHandler((Handler<Throwable>)((Handler)this::failAll)).fetch((Handler<Buffer>)((Handler)buffer -> {
                ServicesRoot sr = (ServicesRoot)Json.decodeValue((String)buffer.toString(), ServicesRoot.class);
                this.log.debug((Object)"Received Service Root: {0}", new Object[]{sr});
                resultHandler.handle((Object)sr);
            }));
        }

        private URI joinPath(String path) {
            try {
                return new URL(this.apiUri.toURL(), path).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void processData() {
            if (this.configs.size() == 0) {
                this.log.warn((Object)"File loaded into registry was empty. No entities created.");
                return;
            }
            try {
                for (Auth3ScaleBean bean : this.configs) {
                    BackendConfiguration config = bean.getThreescaleConfig().getProxyConfig().getBackendConfig();
                    Api api = new Api();
                    api.setApiId(config.getSystemName());
                    api.setOrganizationId(this.defaultOrgName);
                    api.setEndpoint(config.getProxy().getApiBackend());
                    api.setEndpointContentType("text/json");
                    api.setEndpointType("rest");
                    api.setParsePayload(false);
                    api.setPublicAPI(true);
                    api.setVersion(this.defaultVersion);
                    this.setPolicies(api, bean);
                    this.log.debug((Object)"Processing: {0}", new Object[]{config});
                    this.log.debug((Object)"Creating API: {0}", new Object[]{api});
                    this.apis.add(api);
                }
                this.dataProcessed = true;
                this.checkQueue();
            }
            catch (DecodeException e) {
                this.failAll(e);
            }
        }

        private void setPolicies(Api api, Auth3ScaleBean config) {
            Policy pol = new Policy();
            pol.setPolicyImpl(this.determinePolicyImpl());
            pol.setPolicyJsonConfig(Json.encode((Object)config));
            api.getApiPolicies().add(pol);
            this.policyConfigApis.stream().filter(skeleton -> skeleton.getApiId().equals(api.getApiId())).forEach(skeleton -> api.getApiPolicies().addAll(skeleton.getApiPolicies()));
        }

        private String determinePolicyImpl() {
            if (this.config.containsKey("pluginUri")) {
                return this.config.get("pluginUri");
            }
            String version = this.config.getOrDefault("pluginVersion", Version.get().getVersionString());
            return "plugin:io.apiman.plugins:apiman-plugins-3scale-auth:" + version + ":war/io.apiman.plugins.auth3scale.Auth3Scale";
        }

        public synchronized void subscribe(ThreeScaleImmutableRegistry registry, IAsyncResultHandler<Void> failureHandler) {
            Objects.requireNonNull(registry, "registry must be non-null.");
            Objects.requireNonNull(failureHandler, "failure handler must be non-null.");
            this.failureHandlers.add(failureHandler);
            this.allRegistries.add(registry);
            this.awaiting.add(registry);
            this.vertx.runOnContext(action -> this.checkQueue());
        }

        private void checkQueue() {
            if (this.dataProcessed && this.awaiting.size() > 0) {
                this.loadDataIntoRegistries();
            }
        }

        private void loadDataIntoRegistries() {
            ThreeScaleImmutableRegistry reg;
            while ((reg = this.awaiting.poll()) != null) {
                this.log.debug((Object)"Loading data into registry {0}: ", new Object[]{reg});
                for (Api api : this.apis) {
                    reg.publishApiInternal(api, this.handleAnyFailure());
                    this.log.debug((Object)"Publishing: {0} ", new Object[]{api});
                }
                for (Client client : this.clients) {
                    reg.registerClientInternal(client, this.handleAnyFailure());
                    this.log.debug((Object)"Registering: {0} ", new Object[]{client});
                }
            }
            if (this.reloadHandler != null) {
                this.reloadHandler.handle((Object)null);
            }
        }

        private IAsyncResultHandler<Void> handleAnyFailure() {
            return result -> {
                if (result.isError()) {
                    this.failAll(result.getError());
                    throw new RuntimeException(result.getError());
                }
            };
        }

        private void failAll(Throwable cause) {
            AsyncResultImpl failure = AsyncResultImpl.create((Throwable)cause);
            this.failureHandlers.forEach(failureHandler -> this.vertx.runOnContext(run -> failureHandler.handle((Object)failure)));
        }
    }
}

