/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.threescale;

import io.apiman.common.util.ApimanPathUtils;
import io.apiman.gateway.engine.IApiRequestPathParser;
import io.apiman.gateway.engine.beans.util.HeaderMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ThreeScaleRequestPathParser
implements IApiRequestPathParser {
    private final String defaultOrgName;
    private final String defaultVersion;

    public ThreeScaleRequestPathParser(Map<String, String> config) {
        this.defaultOrgName = config.getOrDefault("defaultOrgName", "apiman");
        this.defaultVersion = config.getOrDefault("defaultVersion", "1.0");
    }

    public ApimanPathUtils.ApiRequestPathInfo parseEndpoint(String path, HeaderMap headers) {
        String[] split = StringUtils.split((String)path, (String)"/", (int)3);
        if (split == null || split.length < 2 || !"services".equalsIgnoreCase(split[0])) {
            throw new IllegalArgumentException("Invalid path format, expected /services/serviceName");
        }
        ApimanPathUtils.ApiRequestPathInfo parsed = new ApimanPathUtils.ApiRequestPathInfo();
        parsed.orgId = this.defaultOrgName;
        parsed.apiVersion = this.defaultVersion;
        parsed.apiId = split[1];
        parsed.resource = split.length > 2 ? "/" + split[2] : "/";
        return parsed;
    }
}

