/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.threescale.beans;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fulmicoton.multiregexp.MultiPattern;
import com.fulmicoton.multiregexp.MultiPatternMatcher;
import io.apiman.gateway.engine.threescale.beans.QuerystringParameters;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "proxy_id", "http_method", "pattern", "metric_id", "metric_system_name", "delta", "tenant_id", "created_at", "updated_at", "redirect_url", "parameters", "querystring_parameters"})
public class ProxyRule
implements Serializable {
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="proxy_id")
    private long proxyId;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="pattern")
    private String pattern;
    @JsonProperty(value="metric_id")
    private long metricId;
    @JsonProperty(value="metric_system_name")
    private String metricSystemName;
    @JsonProperty(value="delta")
    private long delta;
    @JsonProperty(value="tenant_id")
    private long tenantId;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    @JsonProperty(value="redirect_url")
    private Object redirectUrl;
    @JsonProperty(value="parameters")
    private List<String> parameters = null;
    @JsonProperty(value="querystring_parameters")
    private QuerystringParameters querystringParameters;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = 5993748206678997809L;
    @JsonIgnore
    private transient Pattern regex;

    private static String convertPattern(ProxyRule bean) {
        String str = bean.getPattern().replaceAll("\\{.+?\\}", "([^/&?]*)");
        return str.endsWith("$") ? str : str + ".*";
    }

    public static void main(String ... proxyRegex) {
        String pattern1 = ProxyRule.convertPattern(new ProxyRule().withPattern("/foo/{bar}/{baz}"));
        String pattern2 = ProxyRule.convertPattern(new ProxyRule().withPattern("/foo/{bar}/somethings"));
        String pattern3 = ProxyRule.convertPattern(new ProxyRule().withPattern("/glue/{bar}/{baz}"));
        MultiPatternMatcher matcher = MultiPattern.of((String[])new String[]{pattern1, pattern2, pattern3}).matcher();
        int[] matching = matcher.match((CharSequence)"/foo/anything/somethings/other");
        System.out.println(Arrays.toString(matching));
    }

    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(long id) {
        this.id = id;
    }

    public ProxyRule withId(long id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="proxy_id")
    public long getProxyId() {
        return this.proxyId;
    }

    @JsonProperty(value="proxy_id")
    public void setProxyId(long proxyId) {
        this.proxyId = proxyId;
    }

    public ProxyRule withProxyId(long proxyId) {
        this.proxyId = proxyId;
        return this;
    }

    @JsonProperty(value="http_method")
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @JsonProperty(value="http_method")
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public ProxyRule withHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @JsonProperty(value="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty(value="pattern")
    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.setRegex(Pattern.compile(ProxyRule.convertPattern(this)));
    }

    public ProxyRule withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @JsonProperty(value="metric_id")
    public long getMetricId() {
        return this.metricId;
    }

    @JsonProperty(value="metric_id")
    public void setMetricId(long metricId) {
        this.metricId = metricId;
    }

    public ProxyRule withMetricId(long metricId) {
        this.metricId = metricId;
        return this;
    }

    @JsonProperty(value="metric_system_name")
    public String getMetricSystemName() {
        return this.metricSystemName;
    }

    @JsonProperty(value="metric_system_name")
    public void setMetricSystemName(String metricSystemName) {
        this.metricSystemName = metricSystemName;
    }

    public ProxyRule withMetricSystemName(String metricSystemName) {
        this.metricSystemName = metricSystemName;
        return this;
    }

    @JsonProperty(value="delta")
    public long getDelta() {
        return this.delta;
    }

    @JsonProperty(value="delta")
    public void setDelta(long delta) {
        this.delta = delta;
    }

    public ProxyRule withDelta(long delta) {
        this.delta = delta;
        return this;
    }

    @JsonProperty(value="tenant_id")
    public long getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenant_id")
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public ProxyRule withTenantId(long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public ProxyRule withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public ProxyRule withUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="redirect_url")
    public Object getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirect_url")
    public void setRedirectUrl(Object redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public ProxyRule withRedirectUrl(Object redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @JsonProperty(value="parameters")
    public List<String> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public ProxyRule withParameters(List<String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty(value="querystring_parameters")
    public QuerystringParameters getQuerystringParameters() {
        return this.querystringParameters;
    }

    @JsonProperty(value="querystring_parameters")
    public void setQuerystringParameters(QuerystringParameters querystringParameters) {
        this.querystringParameters = querystringParameters;
    }

    public ProxyRule withQuerystringParameters(QuerystringParameters querystringParameters) {
        this.querystringParameters = querystringParameters;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProxyRule withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append(this.proxyId).append((Object)this.httpMethod).append((Object)this.pattern).append(this.metricId).append((Object)this.metricSystemName).append(this.delta).append(this.tenantId).append((Object)this.createdAt).append((Object)this.updatedAt).append(this.redirectUrl).append(this.parameters).append((Object)this.querystringParameters).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ProxyRule)) {
            return false;
        }
        ProxyRule rhs = (ProxyRule)other;
        return new EqualsBuilder().append(this.id, rhs.id).append(this.proxyId, rhs.proxyId).append((Object)this.httpMethod, (Object)rhs.httpMethod).append((Object)this.pattern, (Object)rhs.pattern).append(this.metricId, rhs.metricId).append((Object)this.metricSystemName, (Object)rhs.metricSystemName).append(this.delta, rhs.delta).append(this.tenantId, rhs.tenantId).append((Object)this.createdAt, (Object)rhs.createdAt).append((Object)this.updatedAt, (Object)rhs.updatedAt).append(this.redirectUrl, rhs.redirectUrl).append(this.parameters, rhs.parameters).append((Object)this.querystringParameters, (Object)rhs.querystringParameters).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }
}

