/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.threescale.fetchers;

import io.apiman.gateway.engine.vertx.polling.exceptions.BadResponseCodeError;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.impl.Arguments;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Map;

public class AccessTokenResourceFetcher {
    private Vertx vertx;
    private Map<String, String> options;
    private URI apiUri;
    private boolean isHttps;
    private Buffer rawData = Buffer.buffer();
    private Handler<Throwable> exceptionHandler;
    private String accessToken;
    private Logger log = LoggerFactory.getLogger(AccessTokenResourceFetcher.class);

    public AccessTokenResourceFetcher(Vertx vertx, Map<String, String> options, URI uri) {
        this.vertx = vertx;
        this.options = options;
        this.apiUri = uri;
        this.isHttps = uri.getScheme().equals("https");
        this.accessToken = this.requireOpt("accessToken", "accessToken is required in configuration");
    }

    private int getPort() {
        if (this.apiUri.getPort() == -1) {
            if (this.isHttps) {
                return 443;
            }
            return 80;
        }
        return this.apiUri.getPort();
    }

    public void fetch(Handler<Buffer> resultHandler) {
        String path = this.apiUri.getPath() + "?access_token=" + this.accessToken;
        this.vertx.createHttpClient(new HttpClientOptions().setSsl(this.isHttps)).get(this.getPort(), this.apiUri.getHost(), path, clientResponse -> {
            clientResponse.exceptionHandler(this.exceptionHandler);
            if (clientResponse.statusCode() / 100 == 2) {
                clientResponse.handler(data -> {
                    this.rawData.appendBuffer(data);
                    this.log.trace((Object)"Got some data from backend {0}", new Object[]{data});
                }).endHandler(end -> resultHandler.handle((Object)this.rawData));
            } else if (clientResponse.statusCode() == 404) {
                resultHandler.handle((Object)this.rawData);
            } else {
                String errorMessage = MessageFormat.format("Error response code: {0}, message: {1}", clientResponse.statusCode(), clientResponse.statusMessage());
                this.log.error((Object)errorMessage);
                this.exceptionHandler.handle((Object)new BadResponseCodeError(errorMessage));
            }
        }).putHeader("Accept", "application/json").exceptionHandler(this.exceptionHandler).end();
    }

    public AccessTokenResourceFetcher exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    private String requireOpt(String key, String errorMsg) {
        Arguments.require((boolean)this.options.containsKey(key), (String)errorMsg);
        return this.options.get(key);
    }
}

