/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.beans.exceptions.ComponentNotFoundException;
import io.apiman.gateway.engine.components.IPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.impl.DefaultPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.impl.InMemoryRateLimiterComponent;
import io.apiman.gateway.engine.impl.InMemorySharedStateComponent;
import java.util.HashMap;
import java.util.Map;

public class DefaultComponentRegistry
implements IComponentRegistry {
    private Map<Class<? extends IComponent>, IComponent> components = new HashMap<Class<? extends IComponent>, IComponent>();

    public DefaultComponentRegistry() {
        this.components.put(ISharedStateComponent.class, new InMemorySharedStateComponent());
        this.components.put(IRateLimiterComponent.class, new InMemoryRateLimiterComponent());
        this.components.put(IPolicyFailureFactoryComponent.class, new DefaultPolicyFailureFactoryComponent());
    }

    @Override
    public <T extends IComponent> T getComponent(Class<T> componentType) throws ComponentNotFoundException {
        if (this.components.containsKey(componentType)) {
            return (T)this.components.get(componentType);
        }
        throw new ComponentNotFoundException(componentType.getName());
    }
}

