/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class InMemoryRateLimiterComponent
implements IRateLimiterComponent {
    private Map<String, RateLimiterBucket> buckets = new HashMap<String, RateLimiterBucket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(String bucketId, RateBucketPeriod period, int limit, IAsyncResultHandler<Boolean> handler) {
        RateLimiterBucket bucket = null;
        Object object = this.buckets;
        synchronized (object) {
            bucket = this.buckets.get(bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.buckets.put(bucketId, bucket);
            }
        }
        object = bucket.mutex;
        synchronized (object) {
            bucket.resetIfNecessary(period);
            if (bucket.count >= limit) {
                handler.handle((Boolean)((Object)AsyncResultImpl.create(Boolean.FALSE)));
            } else {
                ++bucket.count;
                bucket.last = System.currentTimeMillis();
                handler.handle((Boolean)((Object)AsyncResultImpl.create(Boolean.TRUE)));
            }
        }
    }

    private static class RateLimiterBucket {
        public int count = 0;
        public long last = System.currentTimeMillis();
        public Object mutex = new Object();

        private RateLimiterBucket() {
        }

        public void resetIfNecessary(RateBucketPeriod period) {
            long periodBoundary = this.getLastPeriodBoundary(period);
            if (System.currentTimeMillis() >= periodBoundary) {
                this.count = 0;
            }
        }

        private long getLastPeriodBoundary(RateBucketPeriod period) {
            Calendar lastCal = Calendar.getInstance();
            lastCal.setTimeInMillis(this.last);
            switch (period) {
                case Second: {
                    lastCal.set(14, 0);
                    lastCal.add(13, 1);
                    return lastCal.getTimeInMillis();
                }
                case Minute: {
                    lastCal.set(14, 0);
                    lastCal.set(13, 0);
                    lastCal.add(12, 1);
                    return lastCal.getTimeInMillis();
                }
                case Hour: {
                    lastCal.set(14, 0);
                    lastCal.set(13, 0);
                    lastCal.set(12, 0);
                    lastCal.add(11, 1);
                    return lastCal.getTimeInMillis();
                }
                case Day: {
                    lastCal.set(14, 0);
                    lastCal.set(13, 0);
                    lastCal.set(12, 0);
                    lastCal.set(11, 0);
                    lastCal.add(6, 1);
                    return lastCal.getTimeInMillis();
                }
                case Month: {
                    lastCal.set(14, 0);
                    lastCal.set(13, 0);
                    lastCal.set(12, 0);
                    lastCal.set(11, 0);
                    lastCal.add(5, 1);
                    return lastCal.getTimeInMillis();
                }
                case Year: {
                    lastCal.set(14, 0);
                    lastCal.set(13, 0);
                    lastCal.set(12, 0);
                    lastCal.set(11, 0);
                    lastCal.set(6, 0);
                    lastCal.add(1, 1);
                    return lastCal.getTimeInMillis();
                }
            }
            return Long.MAX_VALUE;
        }
    }
}

