/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.i18n.Messages;
import java.util.HashMap;
import java.util.Map;

public class InMemoryRegistry
implements IRegistry {
    private Map<String, Service> services = new HashMap<String, Service>();
    private Map<String, Application> applications = new HashMap<String, Application>();
    private Map<String, ServiceContract> contracts = new HashMap<String, ServiceContract>();

    @Override
    public synchronized void publishService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (this.services.containsKey(serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceAlreadyPublished", new Object[0]));
        }
        this.services.put(serviceKey, service);
    }

    @Override
    public synchronized void retireService(Service service) throws PublishingException {
        String serviceKey = this.getServiceKey(service);
        if (!this.services.containsKey(serviceKey)) {
            throw new PublishingException(Messages.i18n.format("InMemoryRegistry.ServiceNotFound", new Object[0]));
        }
        this.services.remove(serviceKey);
    }

    @Override
    public synchronized void registerApplication(Application application) throws RegistrationException {
        for (Contract contract : application.getContracts()) {
            if (this.contracts.containsKey(contract.getApiKey())) {
                throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.ContractAlreadyPublished", new Object[]{contract.getApiKey()}));
            }
            String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            if (this.services.containsKey(svcKey)) continue;
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.ServiceNotFoundInOrg", new Object[]{contract.getServiceId(), contract.getServiceOrgId()}));
        }
        String applicationKey = this.getApplicationKey(application);
        if (this.applications.containsKey(applicationKey)) {
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppAlreadyRegistered", new Object[0]));
        }
        this.applications.put(applicationKey, application);
        for (Contract contract : application.getContracts()) {
            String svcKey = this.getServiceKey(contract.getServiceOrgId(), contract.getServiceId(), contract.getServiceVersion());
            ServiceContract sc = new ServiceContract(contract.getApiKey(), this.services.get(svcKey), application, contract.getPolicies());
            this.contracts.put(contract.getApiKey(), sc);
        }
    }

    @Override
    public synchronized void unregisterApplication(Application application) throws RegistrationException {
        String applicationKey = this.getApplicationKey(application);
        if (this.applications.containsKey(applicationKey)) {
            Application removed = this.applications.remove(applicationKey);
            for (Contract contract : removed.getContracts()) {
                if (!this.contracts.containsKey(contract.getApiKey())) continue;
                this.contracts.remove(contract.getApiKey());
            }
        } else {
            throw new RegistrationException(Messages.i18n.format("InMemoryRegistry.AppNotFound", new Object[0]));
        }
    }

    @Override
    public ServiceContract getContract(ServiceRequest request) throws InvalidContractException {
        ServiceContract contract = this.contracts.get(request.getApiKey());
        if (contract == null) {
            throw new InvalidContractException(Messages.i18n.format("InMemoryRegistry.NoContractForAPIKey", new Object[]{request.getApiKey()}));
        }
        return contract;
    }

    private String getServiceKey(Service service) {
        return this.getServiceKey(service.getOrganizationId(), service.getServiceId(), service.getVersion());
    }

    private String getServiceKey(String orgId, String serviceId, String version) {
        return orgId + "|" + serviceId + "|" + version;
    }

    private String getApplicationKey(Application app) {
        return app.getOrganizationId() + "|" + app.getApplicationId() + "|" + app.getVersion();
    }
}

