/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.io;

import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.io.IBuffer;
import io.apiman.gateway.engine.io.IReadWriteStream;

public abstract class AbstractStream<H>
implements IReadWriteStream<H> {
    protected IAsyncHandler<H> headHandler;
    protected IAsyncHandler<IBuffer> bodyHandler;
    protected IAsyncHandler<Void> endHandler;
    protected boolean finished = false;

    public void headHandler(IAsyncHandler<H> headHandler) {
        this.headHandler = headHandler;
    }

    @Override
    public void bodyHandler(IAsyncHandler<IBuffer> bodyHandler) {
        this.bodyHandler = bodyHandler;
    }

    @Override
    public void endHandler(IAsyncHandler<Void> endHandler) {
        this.endHandler = endHandler;
    }

    @Override
    public void write(IBuffer chunk) {
        if (this.bodyHandler != null) {
            this.bodyHandler.handle(chunk);
        }
    }

    @Override
    public void end() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    protected abstract void handleHead(H var1);

    protected void handleBody(IBuffer chunk) {
        if (this.bodyHandler != null) {
            this.bodyHandler.handle(chunk);
        }
    }

    protected void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        this.finished = true;
    }
}

