/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.HashMap;
import java.util.Map;

public class InMemoryRateLimiterComponent
implements IRateLimiterComponent {
    private Map<String, RateLimiterBucket> buckets = new HashMap<String, RateLimiterBucket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(String bucketId, RateBucketPeriod period, int limit, IAsyncResultHandler<Boolean> handler) {
        RateLimiterBucket bucket = null;
        Object object = this.buckets;
        synchronized (object) {
            bucket = this.buckets.get(bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.buckets.put(bucketId, bucket);
            }
        }
        object = bucket.mutex;
        synchronized (object) {
            bucket.resetIfNecessary(period);
            if (bucket.count >= limit) {
                handler.handle((Boolean)((Object)AsyncResultImpl.create(Boolean.FALSE)));
            } else {
                ++bucket.count;
                bucket.last = System.currentTimeMillis();
                handler.handle((Boolean)((Object)AsyncResultImpl.create(Boolean.TRUE)));
            }
        }
    }
}

