/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.IServiceConnector;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.beans.exceptions.RequestAbortedException;
import io.apiman.gateway.engine.impl.EngineResultImpl;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.engine.policy.Chain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import io.apiman.gateway.engine.policy.RequestChain;
import io.apiman.gateway.engine.policy.ResponseChain;
import java.util.List;

public class ServiceRequestExecutorImpl
implements IServiceRequestExecutor {
    private ServiceRequest request;
    private Service service;
    private IPolicyContext context;
    private List<PolicyWithConfiguration> policies;
    private IConnectorFactory connectorFactory;
    private boolean finished = false;
    private IAsyncResultHandler<IEngineResult> resultHandler;
    private IAsyncHandler<PolicyFailure> policyFailureHandler;
    private IAsyncHandler<Throwable> policyErrorHandler;
    private IAsyncHandler<ISignalWriteStream> inboundStreamHandler;
    private Chain<ServiceRequest> requestChain;
    private Chain<ServiceResponse> responseChain;
    private IServiceConnection serviceConnection;
    private IServiceConnectionResponse serviceConnectionResponse;

    public ServiceRequestExecutorImpl(ServiceRequest serviceRequest, IAsyncResultHandler<IEngineResult> resultHandler, Service service, IPolicyContext context, List<PolicyWithConfiguration> policies, IConnectorFactory connectorFactory) {
        this.request = serviceRequest;
        this.resultHandler = resultHandler;
        this.service = service;
        this.context = context;
        this.policies = policies;
        this.connectorFactory = connectorFactory;
        this.policyFailureHandler = this.createPolicyFailureHandler();
        this.policyErrorHandler = this.createPolicyErrorHandler();
    }

    @Override
    public void execute() {
        this.requestChain = this.createRequestChain(new IAsyncHandler<ServiceRequest>(){

            @Override
            public void handle(ServiceRequest request) {
                IServiceConnector connector = ServiceRequestExecutorImpl.this.connectorFactory.createConnector(request, ServiceRequestExecutorImpl.this.service);
                ServiceRequestExecutorImpl.this.serviceConnection = connector.connect(request, ServiceRequestExecutorImpl.this.createServiceConnectionResponseHandler());
                ServiceRequestExecutorImpl.this.requestChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                    @Override
                    public void handle(IApimanBuffer buffer) {
                        ServiceRequestExecutorImpl.this.serviceConnection.write(buffer);
                    }
                });
                ServiceRequestExecutorImpl.this.requestChain.endHandler(new IAsyncHandler<Void>(){

                    @Override
                    public void handle(Void result) {
                        ServiceRequestExecutorImpl.this.serviceConnection.end();
                    }
                });
                ServiceRequestExecutorImpl.this.handleStream();
            }
        });
        this.requestChain.policyFailureHandler(this.policyFailureHandler);
        this.requestChain.doApply(this.request);
    }

    private IAsyncResultHandler<IServiceConnectionResponse> createServiceConnectionResponseHandler() {
        return new IAsyncResultHandler<IServiceConnectionResponse>(){

            @Override
            public void handle(IAsyncResult<IServiceConnectionResponse> result) {
                if (result.isSuccess()) {
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse = result.getResult();
                    ServiceResponse serviceResponse = (ServiceResponse)ServiceRequestExecutorImpl.this.serviceConnectionResponse.getHead();
                    ServiceRequestExecutorImpl.this.context.setAttribute("apiman.engine.serviceResponse", serviceResponse);
                    ServiceRequestExecutorImpl.this.responseChain = ServiceRequestExecutorImpl.this.createResponseChain(new IAsyncHandler<ServiceResponse>(){

                        @Override
                        public void handle(ServiceResponse result) {
                            final EngineResultImpl engineResult = new EngineResultImpl(result);
                            engineResult.setConnectorResponseStream(ServiceRequestExecutorImpl.this.serviceConnectionResponse);
                            ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
                            ServiceRequestExecutorImpl.this.responseChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                                @Override
                                public void handle(IApimanBuffer result) {
                                    engineResult.write(result);
                                }
                            });
                            ServiceRequestExecutorImpl.this.responseChain.endHandler(new IAsyncHandler<Void>(){

                                @Override
                                public void handle(Void result) {
                                    engineResult.end();
                                    ServiceRequestExecutorImpl.this.finished = true;
                                }
                            });
                            ServiceRequestExecutorImpl.this.serviceConnectionResponse.transmit();
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                        @Override
                        public void handle(IApimanBuffer buffer) {
                            ServiceRequestExecutorImpl.this.responseChain.write(buffer);
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.endHandler(new IAsyncHandler<Void>(){

                        @Override
                        public void handle(Void result) {
                            ServiceRequestExecutorImpl.this.responseChain.end();
                        }
                    });
                    ServiceRequestExecutorImpl.this.responseChain.doApply(serviceResponse);
                }
            }
        };
    }

    protected void handleStream() {
        this.inboundStreamHandler.handle(new ISignalWriteStream(){
            boolean streamFinished = false;

            @Override
            public void write(IApimanBuffer buffer) {
                if (this.streamFinished) {
                    throw new IllegalStateException("Attempted write after #end() was called.");
                }
                ServiceRequestExecutorImpl.this.requestChain.write(buffer);
            }

            @Override
            public void end() {
                ServiceRequestExecutorImpl.this.requestChain.end();
                this.streamFinished = true;
            }

            @Override
            public void abort() {
                this.streamFinished = true;
                ServiceRequestExecutorImpl.this.serviceConnection.abort();
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create((Throwable)new RequestAbortedException()));
            }

            @Override
            public boolean isFinished() {
                return this.streamFinished;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void streamHandler(IAsyncHandler<ISignalWriteStream> handler) {
        this.inboundStreamHandler = handler;
    }

    private Chain<ServiceRequest> createRequestChain(IAsyncHandler<ServiceRequest> requestHandler) {
        RequestChain requestChain = new RequestChain(this.policies, this.context);
        requestChain.headHandler(requestHandler);
        requestChain.policyFailureHandler(this.policyFailureHandler);
        requestChain.policyErrorHandler(this.policyErrorHandler);
        return requestChain;
    }

    private Chain<ServiceResponse> createResponseChain(IAsyncHandler<ServiceResponse> responseHandler) {
        ResponseChain responseChain = new ResponseChain(this.policies, this.context);
        responseChain.headHandler(responseHandler);
        responseChain.policyFailureHandler(new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyFailureHandler.handle(result);
            }
        });
        responseChain.policyErrorHandler(new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyErrorHandler.handle(result);
            }
        });
        return responseChain;
    }

    private IAsyncHandler<PolicyFailure> createPolicyFailureHandler() {
        return new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                EngineResultImpl engineResult = new EngineResultImpl(result);
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
            }
        };
    }

    private IAsyncHandler<Throwable> createPolicyErrorHandler() {
        return new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable error) {
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(error));
            }
        };
    }
}

