/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.Version;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.InvalidContractException;
import io.apiman.gateway.engine.beans.exceptions.InvalidServiceException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.i18n.Messages;
import io.apiman.gateway.engine.impl.ServiceRequestExecutorImpl;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import io.apiman.gateway.engine.policy.PolicyContextImpl;
import java.util.List;

public class EngineImpl
implements IEngine {
    private IRegistry registry;
    private IPluginRegistry pluginRegistry;
    private IComponentRegistry componentRegistry;
    private IConnectorFactory connectorFactory;
    private IPolicyFactory policyFactory;

    public EngineImpl(IRegistry registry, IPluginRegistry pluginRegistry, IComponentRegistry componentRegistry, IConnectorFactory connectorFactory, IPolicyFactory policyFactory) {
        this.setRegistry(registry);
        this.setPluginRegistry(pluginRegistry);
        this.setComponentRegistry(componentRegistry);
        this.setConnectorFactory(connectorFactory);
        this.setPolicyFactory(policyFactory);
        policyFactory.setPluginRegistry(pluginRegistry);
    }

    @Override
    public String getVersion() {
        return Version.get().getVersionString();
    }

    @Override
    public IServiceRequestExecutor executor(ServiceRequest request, IAsyncResultHandler<IEngineResult> resultHandler) {
        Service service = null;
        List policies = null;
        if (request.getApiKey() == null) {
            service = this.getService(request.getServiceOrgId(), request.getServiceId(), request.getServiceVersion());
            if (service == null) {
                throw new InvalidServiceException(Messages.i18n.format("EngineImpl.ServiceNotFound", new Object[0]));
            }
            if (!service.isPublicService()) {
                throw new InvalidServiceException(Messages.i18n.format("EngineImpl.ServiceNotPublic", new Object[0]));
            }
            policies = service.getServicePolicies();
        } else {
            ServiceContract serviceContract = this.getContract(request);
            service = serviceContract.getService();
            request.setContract(serviceContract);
            policies = serviceContract.getPolicies();
            if (request.getServiceOrgId() != null) {
                this.validateRequest(request);
            }
        }
        return new ServiceRequestExecutorImpl(request, resultHandler, service, new PolicyContextImpl(this.getComponentRegistry()), policies, this.policyFactory, this.getConnectorFactory());
    }

    protected Service getService(String serviceOrgId, String serviceId, String serviceVersion) {
        return this.getRegistry().getService(serviceOrgId, serviceId, serviceVersion);
    }

    protected void validateRequest(ServiceRequest request) throws InvalidContractException {
        ServiceContract contract = request.getContract();
        boolean matches = true;
        if (!contract.getService().getOrganizationId().equals(request.getServiceOrgId())) {
            matches = false;
        }
        if (!contract.getService().getServiceId().equals(request.getServiceId())) {
            matches = false;
        }
        if (!contract.getService().getVersion().equals(request.getServiceVersion())) {
            matches = false;
        }
        if (!matches) {
            throw new InvalidContractException(Messages.i18n.format("EngineImpl.InvalidContractForService", new Object[]{request.getServiceOrgId(), request.getServiceId(), request.getServiceVersion()}));
        }
    }

    @Override
    public void publishService(Service service) throws PublishingException {
        this.getRegistry().publishService(service);
    }

    @Override
    public void retireService(String organizationId, String serviceId, String version) throws PublishingException {
        Service svc = new Service();
        svc.setOrganizationId(organizationId);
        svc.setServiceId(serviceId);
        svc.setVersion(version);
        this.getRegistry().retireService(svc);
    }

    @Override
    public void registerApplication(Application application) throws RegistrationException {
        this.getRegistry().registerApplication(application);
    }

    @Override
    public void unregisterApplication(String organizationId, String applicationId, String version) throws RegistrationException {
        Application app = new Application();
        app.setOrganizationId(organizationId);
        app.setApplicationId(applicationId);
        app.setVersion(version);
        this.getRegistry().unregisterApplication(app);
    }

    private ServiceContract getContract(ServiceRequest request) {
        return this.getRegistry().getContract(request);
    }

    public IRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IRegistry registry) {
        this.registry = registry;
    }

    public IConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public void setConnectorFactory(IConnectorFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    public IPolicyFactory getPolicyFactory() {
        return this.policyFactory;
    }

    public void setPolicyFactory(IPolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    public IComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(IComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public IPluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public void setPluginRegistry(IPluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }
}

