/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IServiceConnection;
import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.IServiceConnector;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.beans.exceptions.RequestAbortedException;
import io.apiman.gateway.engine.impl.EngineResultImpl;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.engine.policy.Chain;
import io.apiman.gateway.engine.policy.IConnectorInterceptor;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import io.apiman.gateway.engine.policy.RequestChain;
import io.apiman.gateway.engine.policy.ResponseChain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class ServiceRequestExecutorImpl
implements IServiceRequestExecutor {
    private ServiceRequest request;
    private Service service;
    private IPolicyContext context;
    private List<Policy> policies;
    private IPolicyFactory policyFactory;
    private IConnectorFactory connectorFactory;
    private boolean finished = false;
    private List<PolicyWithConfiguration> policyImpls;
    private IAsyncResultHandler<IEngineResult> resultHandler;
    private IAsyncHandler<PolicyFailure> policyFailureHandler;
    private IAsyncHandler<Throwable> policyErrorHandler;
    private IAsyncHandler<ISignalWriteStream> inboundStreamHandler;
    private Chain<ServiceRequest> requestChain;
    private Chain<ServiceResponse> responseChain;
    private IServiceConnection serviceConnection;
    private IServiceConnectionResponse serviceConnectionResponse;

    public ServiceRequestExecutorImpl(ServiceRequest serviceRequest, IAsyncResultHandler<IEngineResult> resultHandler, Service service, IPolicyContext context, List<Policy> policies, IPolicyFactory policyFactory, IConnectorFactory connectorFactory) {
        this.request = serviceRequest;
        this.resultHandler = resultHandler;
        this.service = service;
        this.context = context;
        this.policies = policies;
        this.policyFactory = policyFactory;
        this.connectorFactory = connectorFactory;
        this.policyFailureHandler = this.createPolicyFailureHandler();
        this.policyErrorHandler = this.createPolicyErrorHandler();
        this.policyImpls = new ArrayList<PolicyWithConfiguration>(this.policies.size());
    }

    @Override
    public void execute() {
        this.loadPolicies(new IAsyncHandler<List<PolicyWithConfiguration>>(){

            @Override
            public void handle(List<PolicyWithConfiguration> result) {
                ServiceRequestExecutorImpl.this.policyImpls = result;
                ServiceRequestExecutorImpl.this.requestChain = ServiceRequestExecutorImpl.this.createRequestChain(new IAsyncHandler<ServiceRequest>(){

                    @Override
                    public void handle(ServiceRequest request) {
                        IConnectorInterceptor connectorInterceptor = ServiceRequestExecutorImpl.this.context.getConnectorInterceptor();
                        IServiceConnector connector = null;
                        connector = connectorInterceptor == null ? ServiceRequestExecutorImpl.this.connectorFactory.createConnector(request, ServiceRequestExecutorImpl.this.service) : connectorInterceptor.createConnector();
                        ServiceRequestExecutorImpl.this.serviceConnection = connector.connect(request, ServiceRequestExecutorImpl.this.createServiceConnectionResponseHandler());
                        ServiceRequestExecutorImpl.this.requestChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                            @Override
                            public void handle(IApimanBuffer buffer) {
                                ServiceRequestExecutorImpl.this.serviceConnection.write(buffer);
                            }
                        });
                        ServiceRequestExecutorImpl.this.requestChain.endHandler(new IAsyncHandler<Void>(){

                            @Override
                            public void handle(Void result) {
                                ServiceRequestExecutorImpl.this.serviceConnection.end();
                            }
                        });
                        ServiceRequestExecutorImpl.this.handleStream();
                    }
                });
                ServiceRequestExecutorImpl.this.requestChain.policyFailureHandler(ServiceRequestExecutorImpl.this.policyFailureHandler);
                ServiceRequestExecutorImpl.this.requestChain.doApply(ServiceRequestExecutorImpl.this.request);
            }
        });
    }

    private void loadPolicies(final IAsyncHandler<List<PolicyWithConfiguration>> handler) {
        final HashSet totalCounter = new HashSet();
        final TreeSet errorCounter = new TreeSet();
        final ArrayList<Object> rval = new ArrayList<Object>(this.policies.size());
        final ArrayList<Object> errors = new ArrayList<Object>(this.policies.size());
        final int numPolicies = this.policies.size();
        int index = 0;
        if (this.policies.isEmpty()) {
            handler.handle(this.policyImpls);
            return;
        }
        for (final Policy policy : this.policies) {
            rval.add(null);
            errors.add(null);
            final int localIdx = index++;
            this.policyFactory.loadPolicy(policy.getPolicyImpl(), new IAsyncResultHandler<IPolicy>(){

                @Override
                public void handle(IAsyncResult<IPolicy> result) {
                    if (result.isSuccess()) {
                        IPolicy policyImpl = result.getResult();
                        try {
                            Object policyConfig = ServiceRequestExecutorImpl.this.policyFactory.loadConfig(policyImpl, policy.getPolicyJsonConfig());
                            PolicyWithConfiguration pwc = new PolicyWithConfiguration(policyImpl, policyConfig);
                            rval.set(localIdx, pwc);
                        }
                        catch (Throwable t) {
                            errors.set(localIdx, t);
                            errorCounter.add(localIdx);
                        }
                    } else {
                        Throwable error = result.getError();
                        errors.set(localIdx, error);
                        errorCounter.add(localIdx);
                    }
                    totalCounter.add(localIdx);
                    if (totalCounter.size() == numPolicies) {
                        if (errorCounter.size() > 0) {
                            int errorIdx = (Integer)errorCounter.iterator().next();
                            Throwable error = (Throwable)errors.get(errorIdx);
                            ServiceRequestExecutorImpl.this.policyErrorHandler.handle(error);
                        } else {
                            handler.handle(rval);
                        }
                    }
                }
            });
        }
    }

    private IAsyncResultHandler<IServiceConnectionResponse> createServiceConnectionResponseHandler() {
        return new IAsyncResultHandler<IServiceConnectionResponse>(){

            @Override
            public void handle(IAsyncResult<IServiceConnectionResponse> result) {
                if (result.isSuccess()) {
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse = result.getResult();
                    ServiceResponse serviceResponse = (ServiceResponse)ServiceRequestExecutorImpl.this.serviceConnectionResponse.getHead();
                    ServiceRequestExecutorImpl.this.context.setAttribute("apiman.engine.serviceResponse", serviceResponse);
                    ServiceRequestExecutorImpl.this.responseChain = ServiceRequestExecutorImpl.this.createResponseChain(new IAsyncHandler<ServiceResponse>(){

                        @Override
                        public void handle(ServiceResponse result) {
                            final EngineResultImpl engineResult = new EngineResultImpl(result);
                            engineResult.setConnectorResponseStream(ServiceRequestExecutorImpl.this.serviceConnectionResponse);
                            ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
                            ServiceRequestExecutorImpl.this.responseChain.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                                @Override
                                public void handle(IApimanBuffer result) {
                                    engineResult.write(result);
                                }
                            });
                            ServiceRequestExecutorImpl.this.responseChain.endHandler(new IAsyncHandler<Void>(){

                                @Override
                                public void handle(Void result) {
                                    engineResult.end();
                                    ServiceRequestExecutorImpl.this.finished = true;
                                }
                            });
                            ServiceRequestExecutorImpl.this.serviceConnectionResponse.transmit();
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.bodyHandler(new IAsyncHandler<IApimanBuffer>(){

                        @Override
                        public void handle(IApimanBuffer buffer) {
                            ServiceRequestExecutorImpl.this.responseChain.write(buffer);
                        }
                    });
                    ServiceRequestExecutorImpl.this.serviceConnectionResponse.endHandler(new IAsyncHandler<Void>(){

                        @Override
                        public void handle(Void result) {
                            ServiceRequestExecutorImpl.this.responseChain.end();
                        }
                    });
                    ServiceRequestExecutorImpl.this.responseChain.doApply(serviceResponse);
                }
            }
        };
    }

    protected void handleStream() {
        this.inboundStreamHandler.handle(new ISignalWriteStream(){
            boolean streamFinished = false;

            @Override
            public void write(IApimanBuffer buffer) {
                if (this.streamFinished) {
                    throw new IllegalStateException("Attempted write after #end() was called.");
                }
                ServiceRequestExecutorImpl.this.requestChain.write(buffer);
            }

            @Override
            public void end() {
                ServiceRequestExecutorImpl.this.requestChain.end();
                this.streamFinished = true;
            }

            @Override
            public void abort() {
                this.streamFinished = true;
                ServiceRequestExecutorImpl.this.serviceConnection.abort();
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create((Throwable)new RequestAbortedException()));
            }

            @Override
            public boolean isFinished() {
                return this.streamFinished;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void streamHandler(IAsyncHandler<ISignalWriteStream> handler) {
        this.inboundStreamHandler = handler;
    }

    private Chain<ServiceRequest> createRequestChain(IAsyncHandler<ServiceRequest> requestHandler) {
        RequestChain requestChain = new RequestChain(this.policyImpls, this.context);
        requestChain.headHandler(requestHandler);
        requestChain.policyFailureHandler(this.policyFailureHandler);
        requestChain.policyErrorHandler(this.policyErrorHandler);
        return requestChain;
    }

    private Chain<ServiceResponse> createResponseChain(IAsyncHandler<ServiceResponse> responseHandler) {
        ResponseChain responseChain = new ResponseChain(this.policyImpls, this.context);
        responseChain.headHandler(responseHandler);
        responseChain.policyFailureHandler(new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyFailureHandler.handle(result);
            }
        });
        responseChain.policyErrorHandler(new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable result) {
                ServiceRequestExecutorImpl.this.serviceConnectionResponse.abort();
                ServiceRequestExecutorImpl.this.policyErrorHandler.handle(result);
            }
        });
        return responseChain;
    }

    private IAsyncHandler<PolicyFailure> createPolicyFailureHandler() {
        return new IAsyncHandler<PolicyFailure>(){

            @Override
            public void handle(PolicyFailure result) {
                EngineResultImpl engineResult = new EngineResultImpl(result);
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(engineResult));
            }
        };
    }

    private IAsyncHandler<Throwable> createPolicyErrorHandler() {
        return new IAsyncHandler<Throwable>(){

            @Override
            public void handle(Throwable error) {
                ServiceRequestExecutorImpl.this.resultHandler.handle(AsyncResultImpl.create(error));
            }
        };
    }
}

