/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.async;

import io.apiman.gateway.engine.async.IAsyncResult;

public class AsyncResultImpl<T>
implements IAsyncResult<T> {
    private T result;
    private Throwable error;

    public static final <T> AsyncResultImpl<T> create(T result) {
        return new AsyncResultImpl<T>(result);
    }

    public static final <T> AsyncResultImpl<T> create(Throwable t) {
        return new AsyncResultImpl<T>(t);
    }

    public static final <T> AsyncResultImpl<T> create(Throwable t, Class<T> type) {
        return new AsyncResultImpl<T>(t);
    }

    private AsyncResultImpl(T result) {
        this.result = result;
    }

    private AsyncResultImpl(Throwable error) {
        this.error = error;
    }

    @Override
    public boolean isSuccess() {
        return this.error == null;
    }

    @Override
    public boolean isError() {
        return this.error != null;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }
}

