/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.policy;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.exceptions.PolicyNotFoundException;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import java.util.HashMap;
import java.util.Map;

public class PolicyFactoryImpl
implements IPolicyFactory {
    private IPluginRegistry pluginRegistry;
    private Map<String, IPolicy> policyCache = new HashMap<String, IPolicy>();
    private Map<String, Object> policyConfigCache = new HashMap<String, Object>();

    @Override
    public void setPluginRegistry(IPluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    @Override
    public Object loadConfig(IPolicy policy, String configData) {
        if (this.policyConfigCache.containsKey(configData)) {
            return this.policyConfigCache.get(configData);
        }
        Object config = policy.parseConfiguration(configData);
        this.policyConfigCache.put(configData, config);
        return config;
    }

    @Override
    public void loadPolicy(String policyImpl, IAsyncResultHandler<IPolicy> handler) {
        if (policyImpl == null) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl))));
            return;
        }
        if (this.policyCache.containsKey(policyImpl)) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create(this.policyCache.get(policyImpl))));
            return;
        }
        if (policyImpl.startsWith("class:")) {
            this.doLoadFromClasspath(policyImpl, handler);
        } else if (policyImpl.startsWith("plugin:")) {
            this.doLoadFromPlugin(policyImpl, handler);
        } else {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl))));
        }
    }

    protected void doLoadFromClasspath(String policyImpl, IAsyncResultHandler<IPolicy> handler) {
        IPolicy rval = null;
        String classname = policyImpl.substring(6);
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (c == null) {
            try {
                c = this.getClass().getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(classname))));
            return;
        }
        try {
            rval = (IPolicy)c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl, (Throwable)e))));
            return;
        }
        this.policyCache.put(policyImpl, rval);
        handler.handle((IPolicy)((Object)AsyncResultImpl.create(rval)));
    }

    private void doLoadFromPlugin(final String policyImpl, final IAsyncResultHandler<IPolicy> handler) {
        PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)policyImpl);
        if (coordinates == null) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl))));
            return;
        }
        int ssidx = policyImpl.indexOf(47);
        if (ssidx == -1) {
            handler.handle((IPolicy)((Object)AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl))));
            return;
        }
        final String classname = policyImpl.substring(ssidx + 1);
        this.pluginRegistry.loadPlugin(coordinates, new IAsyncResultHandler<Plugin>(){

            @Override
            public void handle(IAsyncResult<Plugin> result) {
                if (result.isSuccess()) {
                    IPolicy rval = null;
                    Plugin plugin = result.getResult();
                    PluginClassLoader pluginClassLoader = plugin.getLoader();
                    try {
                        Class c = pluginClassLoader.loadClass(classname);
                        rval = (IPolicy)c.newInstance();
                    }
                    catch (Exception e) {
                        handler.handle(AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl, (Throwable)e)));
                        return;
                    }
                    PolicyFactoryImpl.this.policyCache.put(policyImpl, rval);
                    handler.handle(AsyncResultImpl.create(rval));
                } else {
                    handler.handle(AsyncResultImpl.create((Throwable)new PolicyNotFoundException(policyImpl, result.getError())));
                }
            }
        });
    }
}

