/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginSpec;
import io.apiman.common.plugin.PluginUtils;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.i18n.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DefaultPluginRegistry
implements IPluginRegistry {
    private File pluginsDir;
    private Map<PluginCoordinates, Plugin> pluginCache = new HashMap<PluginCoordinates, Plugin>();
    private Set<URL> pluginRepositories;

    private static File createTempPluginsDir() {
        try {
            File tempDir = File.createTempFile("_apiman", "plugins");
            tempDir.delete();
            tempDir.mkdir();
            return tempDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getConfiguredPluginsDir(Map<String, String> configMap) {
        String pluginsDirPath = configMap.get("pluginsDir");
        if (pluginsDirPath != null) {
            File file = new File(pluginsDirPath).getAbsoluteFile();
            if (!file.exists()) {
                file.mkdirs();
            } else if (file.isFile()) {
                throw new RuntimeException("Invalid plugins directory: " + file.toString());
            }
            return file;
        }
        return DefaultPluginRegistry.createTempPluginsDir();
    }

    private static Set<URL> getConfiguredPluginRepositories(Map<String, String> configMap) {
        HashSet<URL> rval = new HashSet<URL>();
        rval.addAll(PluginUtils.getDefaultMavenRepositories());
        String repositories = configMap.get("pluginRepositories");
        if (repositories != null) {
            String[] split;
            for (String repository : split = repositories.split(",")) {
                try {
                    String trimmedRepo = repository.trim();
                    if (trimmedRepo.isEmpty()) continue;
                    rval.add(new URL(trimmedRepo));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return rval;
    }

    public DefaultPluginRegistry() {
        this(DefaultPluginRegistry.createTempPluginsDir(), PluginUtils.getDefaultMavenRepositories());
    }

    public DefaultPluginRegistry(Map<String, String> configMap) {
        this(DefaultPluginRegistry.getConfiguredPluginsDir(configMap), DefaultPluginRegistry.getConfiguredPluginRepositories(configMap));
    }

    public DefaultPluginRegistry(File pluginsDir, Set<URL> pluginRepositories) {
        this.pluginsDir = pluginsDir;
        this.pluginRepositories = pluginRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPlugin(PluginCoordinates coordinates, IAsyncResultHandler<Plugin> handler) {
        Plugin plugin = null;
        Exception error = null;
        Map<PluginCoordinates, Plugin> map = this.pluginCache;
        synchronized (map) {
            if (this.pluginCache.containsKey(coordinates)) {
                plugin = this.pluginCache.get(coordinates);
            } else {
                File pluginFile;
                String pluginRelativePath = PluginUtils.getPluginRelativePath((PluginCoordinates)coordinates);
                File pluginDir = new File(this.pluginsDir, pluginRelativePath);
                if (!pluginDir.exists()) {
                    pluginDir.mkdirs();
                }
                if (!(pluginFile = new File(pluginDir, "plugin." + coordinates.getType())).exists()) {
                    this.copyFromM2(pluginFile, coordinates);
                }
                if (!pluginFile.exists()) {
                    this.downloadPlugin(pluginFile, coordinates);
                }
                if (!pluginFile.exists()) {
                    error = new Exception(Messages.i18n.format("DefaultPluginRegistry.PluginNotFound", new Object[0]));
                } else {
                    try {
                        PluginClassLoader pluginClassLoader = this.createPluginClassLoader(pluginFile);
                        URL specFile = pluginClassLoader.getResource("META-INF/apiman/plugin.json");
                        if (specFile == null) {
                            error = new Exception(Messages.i18n.format("DefaultPluginRegistry.MissingPluginSpecFile", new Object[]{"META-INF/apiman/plugin.json"}));
                        } else {
                            PluginSpec spec = PluginUtils.readPluginSpecFile((URL)specFile);
                            plugin = new Plugin(spec, coordinates, pluginClassLoader);
                            this.pluginCache.put(coordinates, plugin);
                        }
                    }
                    catch (Exception e) {
                        error = new Exception(Messages.i18n.format("DefaultPluginRegistry.InvalidPlugin", new Object[]{pluginFile.getAbsolutePath()}), e);
                    }
                }
            }
        }
        if (error != null) {
            handler.handle((Plugin)AsyncResultImpl.create(error));
        } else if (plugin != null) {
            handler.handle((Plugin)AsyncResultImpl.create(plugin));
        } else {
            handler.handle((Plugin)AsyncResultImpl.create(new Exception("Failed to load plugin (unknown reason).")));
        }
    }

    protected PluginClassLoader createPluginClassLoader(final File pluginFile) throws IOException {
        PluginClassLoader cl = new PluginClassLoader(pluginFile, Thread.currentThread().getContextClassLoader()){

            protected File createWorkDir(File pluginArtifactFile) throws IOException {
                File workDir = new File(pluginFile.getParentFile(), ".work");
                workDir.mkdirs();
                return workDir;
            }
        };
        return cl;
    }

    protected void copyFromM2(File pluginFile, PluginCoordinates coordinates) {
        File artifactFile;
        File m2Dir = PluginUtils.getUserM2Repository();
        String m2Override = System.getProperty("apiman.gateway.m2-repository-path");
        if (m2Override != null) {
            m2Dir = new File(m2Override).getAbsoluteFile();
        }
        if (m2Dir != null && (artifactFile = PluginUtils.getM2Path((File)m2Dir, (PluginCoordinates)coordinates)).isFile()) {
            try {
                FileUtils.copyFile((File)artifactFile, (File)pluginFile);
                return;
            }
            catch (IOException e) {
                artifactFile.delete();
            }
        }
    }

    protected void downloadPlugin(File pluginFile, PluginCoordinates coordinates) {
        for (URL mavenRepoUrl : this.pluginRepositories) {
            if (!this.downloadFromMavenRepo(pluginFile, coordinates, mavenRepoUrl)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean downloadFromMavenRepo(File pluginFile, PluginCoordinates coordinates, URL mavenRepoUrl) {
        boolean bl;
        String artifactSubPath = PluginUtils.getMavenPath((PluginCoordinates)coordinates);
        InputStream istream = null;
        FileOutputStream ostream = null;
        try {
            URL artifactUrl = new URL(mavenRepoUrl, artifactSubPath);
            istream = artifactUrl.openStream();
            ostream = new FileOutputStream(pluginFile);
            IOUtils.copy((InputStream)istream, (OutputStream)ostream);
            ostream.flush();
            bl = true;
            IOUtils.closeQuietly((InputStream)istream);
        }
        catch (Exception e) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            IOUtils.closeQuietly(istream);
            IOUtils.closeQuietly(ostream);
        }
        IOUtils.closeQuietly((OutputStream)ostream);
        return bl;
    }
}

