/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.metrics.impl.influxdb;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IHttpClientComponent;
import io.apiman.gateway.engine.components.http.HttpMethod;
import io.apiman.gateway.engine.components.http.IHttpClientRequest;
import io.apiman.gateway.engine.components.http.IHttpClientResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class InfluxDb09Driver {
    private IHttpClientComponent httpClient;
    private String endpoint;
    private String username;
    private String password;
    private String writeQuery;
    private static ObjectMapper objectMapper = new ObjectMapper();

    public InfluxDb09Driver(IHttpClientComponent httpClient, String endpoint, String username, String password) {
        this.httpClient = httpClient;
        this.endpoint = endpoint;
        this.username = username;
        this.password = password;
        this.writeQuery = this.buildParams(new StringBuffer(endpoint + "/write"), null).toString();
    }

    public void write(String jsonDocument, String encoding, final IAsyncHandler<InfluxException> failureHandler) {
        IHttpClientRequest request = this.httpClient.request(this.writeQuery, HttpMethod.POST, new IAsyncResultHandler<IHttpClientResponse>(){

            @Override
            public void handle(IAsyncResult<IHttpClientResponse> result) {
                if (result.isError() || result.getResult().getResponseCode() != 200) {
                    failureHandler.handle(new InfluxException(result.getResult()));
                }
            }
        });
        request.addHeader("Content-Type", "application/json");
        request.write(jsonDocument, encoding);
        request.end();
    }

    public void listDatabases(final IAsyncResultHandler<List<String>> handler) {
        StringBuffer url = new StringBuffer(this.endpoint + "/query");
        this.buildParams(url, "SHOW DATABASES");
        IHttpClientRequest request = this.httpClient.request(url.toString(), HttpMethod.GET, new IAsyncResultHandler<IHttpClientResponse>(){

            @Override
            public void handle(IAsyncResult<IHttpClientResponse> result) {
                try {
                    if (result.isError() || result.getResult().getResponseCode() != 200) {
                        InfluxDb09Driver.this.handleError(result, handler);
                        return;
                    }
                    ArrayList results = new ArrayList();
                    JsonNode arrNode = (JsonNode)((JsonNode)objectMapper.readTree(result.getResult().getBody()).path("results").getElements().next()).path("series").getElements().next();
                    InfluxDb09Driver.this.flattenArrays(arrNode.get("values"), results);
                    handler.handle(AsyncResultImpl.create(results));
                }
                catch (IOException e) {
                    AsyncResultImpl.create(new RuntimeException("Unable to parse Influx JSON response", e));
                }
            }
        });
        request.end();
    }

    protected <T> void handleError(IAsyncResult<IHttpClientResponse> result, IAsyncResultHandler<T> handler) {
        if (result.isError()) {
            handler.handle(AsyncResultImpl.create(result.getError()));
        } else if (result.getResult().getResponseCode() != 200) {
            handler.handle(AsyncResultImpl.create(new RuntimeException("Influx: " + result.getResult().getResponseCode() + " " + result.getResult().getResponseMessage())));
        }
    }

    private void flattenArrays(JsonNode arrNode, List<String> results) {
        if (arrNode.isArray()) {
            for (JsonNode entry : arrNode) {
                this.flattenArrays(entry, results);
            }
        } else {
            results.add(arrNode.getTextValue());
        }
    }

    private StringBuffer buildParams(StringBuffer url, String query) {
        url.append("?");
        this.addQueryParam(url, "u", this.username);
        this.addQueryParam(url, "p", this.password);
        if (query != null) {
            this.addQueryParam(url, "q", query);
        }
        return url;
    }

    private StringBuffer addQueryParam(StringBuffer url, String key, String value) {
        try {
            url.append("&" + key + "=" + URLEncoder.encode(value, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public final class InfluxException
    extends RuntimeException {
        private static final long serialVersionUID = 3481055452967828740L;
        private IHttpClientResponse response;
        private RuntimeException exception;

        public InfluxException(IHttpClientResponse r) {
            this.response = r;
        }

        public InfluxException(RuntimeException e) {
            super(e);
            this.exception = e;
        }

        public boolean isBadResponse() {
            return this.response != null;
        }

        public IHttpClientResponse getResponse() {
            return this.response;
        }

        public boolean isException() {
            return this.exception != null;
        }

        public RuntimeException getException() {
            return this.exception;
        }
    }
}

