/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.rates;

import io.apiman.gateway.engine.rates.RateBucketPeriod;
import java.io.Serializable;
import java.util.Calendar;

public class RateLimiterBucket
implements Serializable {
    private static final long serialVersionUID = 7322973438395289398L;
    public int count = 0;
    public long last = System.currentTimeMillis();

    public void resetIfNecessary(RateBucketPeriod period) {
        long periodBoundary = this.getLastPeriodBoundary(period);
        if (System.currentTimeMillis() >= periodBoundary) {
            this.count = 0;
        }
    }

    public long getResetMillis(RateBucketPeriod period) {
        long now = System.currentTimeMillis();
        long periodBoundary = RateLimiterBucket.getPeriodBoundary(now, period);
        return periodBoundary - now;
    }

    private long getLastPeriodBoundary(RateBucketPeriod period) {
        return RateLimiterBucket.getPeriodBoundary(this.last, period);
    }

    private static long getPeriodBoundary(long timestamp, RateBucketPeriod period) {
        Calendar lastCal = Calendar.getInstance();
        lastCal.setTimeInMillis(timestamp);
        switch (period) {
            case Second: {
                lastCal.set(14, 0);
                lastCal.add(13, 1);
                return lastCal.getTimeInMillis();
            }
            case Minute: {
                lastCal.set(14, 0);
                lastCal.set(13, 0);
                lastCal.add(12, 1);
                return lastCal.getTimeInMillis();
            }
            case Hour: {
                lastCal.set(14, 0);
                lastCal.set(13, 0);
                lastCal.set(12, 0);
                lastCal.add(11, 1);
                return lastCal.getTimeInMillis();
            }
            case Day: {
                lastCal.set(14, 0);
                lastCal.set(13, 0);
                lastCal.set(12, 0);
                lastCal.set(11, 0);
                lastCal.add(6, 1);
                return lastCal.getTimeInMillis();
            }
            case Month: {
                lastCal.set(14, 0);
                lastCal.set(13, 0);
                lastCal.set(12, 0);
                lastCal.set(11, 0);
                lastCal.add(5, 1);
                return lastCal.getTimeInMillis();
            }
            case Year: {
                lastCal.set(14, 0);
                lastCal.set(13, 0);
                lastCal.set(12, 0);
                lastCal.set(11, 0);
                lastCal.set(6, 0);
                lastCal.add(1, 1);
                return lastCal.getTimeInMillis();
            }
        }
        return Long.MAX_VALUE;
    }
}

